% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{dropTRIGGER}
\alias{dropTRIGGER}
\title{Generate a PostgreSQL DROP TRIGGER statement, optionally execute the statement if con is not NULL.}
\usage{
dropTRIGGER(
  name,
  on,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for PostgreSQL DROP TRIGGER.}

\item{on}{A string, the "table_name" parameter for PostgreSQL DROP TRIGGER.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to PostgreSQL DROP TRIGGER statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to PostgreSQL DROP TRIGGER statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to PostgreSQL DROP TRIGGER statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL DROP TRIGGER statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL DROP TRIGGER statement, optionally execute the statement if con is not NULL.
}
\examples{
dropTRIGGER(
name = "sample_trigger",
on = "sample_table"
)
}
