/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectName;

public abstract class PSColor
implements Cloneable {
    private double[] levels;

    public PSColor clone() throws CloneNotSupportedException {
        PSColor pSColor = (PSColor)super.clone();
        if (this.levels != null) {
            pSColor.levels = (double[])this.levels.clone();
        }
        return pSColor;
    }

    public abstract double[] getCMYK();

    public abstract PSObjectArray getColorSpace();

    public abstract double getGray();

    public abstract double[] getHSB();

    public abstract PSObjectName getFamilyName();

    public abstract int getNrComponents();

    public abstract int getNrInputValues();

    public abstract double[] getRGB();

    public void setColor(double[] dArray) throws PSError, ProgramError {
        int n = this.getNrInputValues();
        if (dArray.length != n) {
            throw new PSErrorRangeCheck();
        }
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            d = Math.min(d, 1.0);
            d = Math.max(d, 0.0);
            this.setLevel(i, d);
        }
    }

    protected void setLevel(int n, double d) {
        if (this.levels == null) {
            this.levels = new double[this.getNrComponents()];
        }
        this.levels[n] = d;
    }

    public abstract String getPreferredColorSpace();

    public double getLevel(int n) {
        return this.levels[n];
    }
}

