/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.Closepath;
import net.sf.eps2pgf.ps.Curveto;
import net.sf.eps2pgf.ps.GstateStack;
import net.sf.eps2pgf.ps.Lineto;
import net.sf.eps2pgf.ps.Moveto;
import net.sf.eps2pgf.ps.PathSection;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorNoCurrentPoint;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
implements Cloneable {
    private ArrayList<PathSection> sections = new ArrayList();
    private GstateStack gStateStack;
    private static final Logger LOG = Logger.getLogger("net.sourceforge.eps2pgf");

    public Path(GstateStack gstateStack) {
        this.gStateStack = gstateStack;
    }

    public double[] boundingBox() throws PSErrorNoCurrentPoint {
        int n = this.getSections().size();
        if (n < 1) {
            throw new PSErrorNoCurrentPoint();
        }
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < n; ++i) {
            PathSection pathSection = this.getSections().get(i);
            if (n > 1 && i == n - 1 && pathSection instanceof Moveto) break;
            for (int j = 0; j < pathSection.nrParams() && !Double.isNaN(pathSection.getParam(j)) && !Double.isNaN(pathSection.getParam(j + 1)); j += 2) {
                dArray[0] = Math.min(dArray[0], pathSection.getParam(j));
                dArray[1] = Math.min(dArray[1], pathSection.getParam(j + 1));
                dArray[2] = Math.max(dArray[2], pathSection.getParam(j));
                dArray[3] = Math.max(dArray[3], pathSection.getParam(j + 1));
            }
        }
        return dArray;
    }

    public Path clone() {
        Path path;
        LOG.finest("Path clone() called.");
        try {
            path = (Path)super.clone();
            path.sections = new ArrayList();
            path.gStateStack = this.gStateStack;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            path = new Path(this.gStateStack);
        }
        for (int i = 0; i < this.getSections().size(); ++i) {
            path.getSections().add(this.getSections().get(i).clone());
        }
        return path;
    }

    public double[] closepath() throws PSErrorRangeCheck, PSErrorTypeCheck {
        int n = this.getSections().size();
        if (n == 0) {
            return null;
        }
        if (this.getSections().get(n - 1) instanceof Moveto) {
            return null;
        }
        double[] dArray = new double[]{Double.NaN, Double.NaN};
        for (int i = n - 1; i >= 0; --i) {
            PathSection pathSection = this.getSections().get(i);
            if (!(pathSection instanceof Moveto)) continue;
            dArray = this.gStateStack.current().getCtm().itransform(pathSection.getParam(0), pathSection.getParam(1));
            break;
        }
        Closepath closepath = new Closepath(dArray);
        this.getSections().add(closepath);
        return dArray;
    }

    public Path flattenpath(double d) throws PSError, ProgramError {
        Path path = new Path(this.gStateStack);
        PathSection pathSection = new PathSection();
        for (PathSection pathSection2 : this.getSections()) {
            if (pathSection2 instanceof Moveto) {
                path.moveto(pathSection2.getParam(0), pathSection2.getParam(1));
            } else if (pathSection2 instanceof Lineto) {
                path.lineto(pathSection2.getParam(0), pathSection2.getParam(1));
            } else if (pathSection2 instanceof Closepath) {
                path.closepath();
            } else if (pathSection2 instanceof Curveto) {
                ((Curveto)pathSection2).flatten(path, pathSection.deviceCoor(), d);
            } else {
                throw new ProgramError("You've found a bug. Flattening this (" + pathSection2 + ") type is not implemented.");
            }
            pathSection = pathSection2;
        }
        return path;
    }

    public void moveto(double d, double d2) {
        PathSection pathSection;
        int n = this.getSections().size();
        if (n > 0 && (pathSection = this.getSections().get(n - 1)) instanceof Moveto) {
            this.getSections().remove(n - 1);
        }
        this.getSections().add(new Moveto(d, d2));
    }

    public void lineto(double d, double d2) {
        this.getSections().add(new Lineto(d, d2));
    }

    public void curveto(double[] dArray, double[] dArray2, double[] dArray3) {
        this.getSections().add(new Curveto(dArray, dArray2, dArray3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path (" + this.getSections().size() + " items)\n");
        for (int i = 0; i < this.getSections().size(); ++i) {
            stringBuilder.append(this.getSections().get(i).toString() + "\n");
        }
        return stringBuilder.toString();
    }

    public ArrayList<PathSection> getSections() {
        return this.sections;
    }
}

