% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-footer.R
\name{hf_line}
\alias{hf_line}
\title{Create a title line container}
\usage{
hf_line(
  ...,
  align = c("center", "left", "right", "split"),
  bold = FALSE,
  italic = FALSE,
  font = NA,
  font_size = NA,
  index = NA
)
}
\arguments{
\item{...}{A character list/vector. If \code{length(...)} is 2 and
\code{align} is not 'split', values are pasted together.}

\item{align}{Text alignment in document. Options are 'center', 'left',
'right', and 'split'. A 'split' alignment will left align the string in
 the first text item and right align the second. Defaults to center.}

\item{bold}{\code{TRUE} or  \code{FALSE}. Defaults to FALSE.}

\item{italic}{\code{TRUE} or  \code{FALSE}. Defaults to FALSE.}

\item{font}{A string to specify the font display. Ensure the intended RTF
reader can display the selected font. Fonts for all fields will default to
the default font of the \code{rtf_doc} object, which unless otherwise
assigned, is Courier New.}

\item{font_size}{Font size in points. Font sizes for all fields will default to
the default font size of the \code{rtf_doc} object, which unless otherwise
assigned, is 12}

\item{index}{Position to display header or footnote lines in the RTF
document. Orders in ascending order with NAs last. Defaults to NA.}
}
\value{
An object of class \code{hf_line} with the properties described in
  the Arguments section.
}
\description{
\code{hf_line} objects represent individual title or footnote lines and
their associated metadata. These objects are passed to an \code{rtf_doc} for
display in the header or footer of an RTF document.

A character vector of length <= 2 describes the text to display. Using a
single text element, the text can be aligned left, right, or center. Using
two text elements, the alignment can be set to “split”, which will left
align the first element, and right align the second. If alignment is set to
anything else, the text elements will be pasted together.

Lines can either be passed to the titles/footnotes arguments in the call to
\code{rtf_doc} or added later with the \code{add_titles} or
\code{add_footnotes} functions. Supported properties are detailed in the
arguments section.
}
\section{Supported Formatting}{

Several special display formats are supported to display document data. When
the \code{rtf_doc} is written, the package will determine if the text of an
\code{hf_line} object starts with a keyword. Regular expression matching and
replacement is used for formatting.
\itemize{
\item{PAGE_FORMAT: - Can take up to two replacements to format current
  page(first), and total number of pages(second). Page numbers are replaced in
  the string using \%s For example, for a format of Page 1 of 5, use
  PAGE_FORMAT: Page \%s of \%s. For a format of just 5, use
  PAGE_FORMAT: \%s.}
\item{DATE_FORMAT: - Describes the date/time the document was generated.
  Formats are specified using standard R date formatting tokens. Details on
  formatting dates can be found
  \href{https://www.r-bloggers.com/date-formats-in-r/}{here}.}
\item{FILE_PATH: - Describes the file path the R session was executed from.
The location of the executing file will be populated over the token
replacement string "\%s". Formats can be specified like "FILE_PATH: Executed
from: \%s" or simply "FILE_PATH: \%s". Note that the location of the executing
file in R may not be intuitive. There are multiple ways to determine the
containing R file based on how it was executed.
  \itemize{
    \item{When the file is executed using \code{Rscript}, this field will
      populated as the executed Rscript file.}
    \item{When the file is sourced, this field will populate with the
      location of the sourced file.}
    \item{When a file is run interactively (i.e. from the R console), this
      field will populate as <run interactively>.}
  }}
}
}

\examples{
# Adding lines during rtf_doc construction
ht <- huxtable::huxtable(
 column1 = 1:5,
 column2 = letters[1:5]
)
titles_l <- list(
  hf_line(c("The Title Left", "The Titles Right"), align = "split"),
  hf_line("A Bold, italic Title", bold = TRUE, italic = TRUE,
    align = "left", font_size = 20, font = "Times New Roman")
)
rtf <- rtf_doc(ht, titles = titles_l)

# Adding lines after rtf_doc construction
rtf <- add_footnotes(rtf,
    hf_line("PAGE_FORMAT: Page \%s of \%s"),
    hf_line("DATE_FORMAT: \%H:\%M \%A, \%B \%d, \%Y"),
    hf_line("FILE_PATH: Source: \%s")
  )

}
