% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{plot_cwres_vs_idv}
\alias{plot_cwres_vs_idv}
\title{plot_cwres_vs_idv}
\usage{
plot_cwres_vs_idv(model, residuals, stratify_on = NULL, bins = 8)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{residuals}{(data.frame) DataFrame containing CWRES}

\item{stratify_on}{(str (optional)) Name of parameter for stratification}

\item{bins}{(numeric) Number of bins for stratification}
}
\value{
(alt.Chart) Plot
}
\description{
Plot CWRES vs idv
}
\examples{
\dontrun{
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_cwres_vs_idv(model, res$residuals)
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_cwres_vs_idv(model, res$residuals, 'WGT', bins=4)
}

}
