% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_ci.R
\name{mean_ci}
\alias{mean_ci}
\title{Calculating the confidence intervals (CIs) of an arithmetic mean.}
\usage{
mean_ci(observations, bootstraps = 1e+05, conf = 0.95, type = "bca")
}
\arguments{
\item{observations}{A vector of observations given as numeric values}

\item{bootstraps}{The number of bootstraps you want to run to create the CIs,
defaults to 100000}

\item{conf}{The confidence level wanted. Defaults to 95\% CI.}

\item{type}{A vector of character strings representing the type of intervals
required to calculate the CI. Defaults to "bca". See ??boot.ci
for more information.}
}
\value{
The estimated CIs around a mean estimate.
}
\description{
\code{mean_ci}Function estimates CIs using nonparametric bootstrapping around a
mean estimate.
}
\section{Functions}{
\itemize{
\item \code{mean_ci}: Estimates CIs around a mean percentile estimate using
non-parameteric bootstrapping from the boot package
}}

\examples{
# Estimate when the mean observation of Rudbeckia hirta for the year 2019 up
# to October

r_hirta <- subset(inat_examples, scientific_name == "Rudbeckia hirta")
mean_ci(observations = r_hirta$doy , bootstraps = 100)

# note low number of bootstraps for quick processing speed

}
\keyword{estimates}
\keyword{mean}
\keyword{phenology}
