% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_nlminb.R
\name{opt_nlminb_julia}
\alias{opt_nlminb_julia}
\title{Optimization using PORT routines}
\usage{
opt_nlminb_julia(
  par0,
  fitMeth = "doubleLog_Beck",
  y,
  t,
  w = NULL,
  ylu = NULL,
  lower = NULL,
  upper = NULL,
  ...
)
}
\arguments{
\item{par0}{Initial values for the parameters to be optimized over.}

\item{fitMeth}{Curve fitting methods, one of \code{c("doubleLog_Beck", "doubleLog_Elmore", "doubleLog_AG", "doubleLog_Zhang")}}

\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{ylu}{\verb{ymin, ymax}, which is used to force \code{ypred} in the
range of \code{ylu}.}

\item{lower}{
    vectors of lower and upper bounds, replicated to be as long as
    \code{start}.  If unspecified, all parameters are assumed to be
    unconstrained.
  }

\item{upper}{
    vectors of lower and upper bounds, replicated to be as long as
    \code{start}.  If unspecified, all parameters are assumed to be
    unconstrained.
  }

\item{...}{ignored parameters}
}
\value{
A list object of
\itemize{
\item \code{par}: The optimal parameters
\item \code{convergence}:
\itemize{
\item 0: convergent;
\item 1: Non-convergent
}
\item iterations
\item evaluations: list(function, gradient)
\item objective
}
}
\description{
Unconstrained and box-constrained optimization using PORT routines.
}
\examples{
\dontrun{

t    = seq(1.0, 366, 8)
fun  = doubleLog_Beck
par  = c(0.1 , 0.7, 50, 0.1, 250, 0.1)
par0 = c(0.05, 0.6 , 45, 0.1, 200, 0.2)

ypred = t*0
y     = fun(par, t)

julia_init()
r_julia  <- opt_nlminb_julia(par0, "doubleLog_Beck", y, t)
r_R <- opt_nlminb(par0, f_goal, fun = fun, y = y, t = t, pred = ypred)

list(julia = r_julia, R = r_R) \%>\%
    map(~c(.$par, .$objective, .$value)) \%>\%
    do.call(rbind, .)# \%>\%

n <- length(t)
w <- rep(0.2, n)
# julia is 5 times faster
{
    # microbenchmark::microbenchmark : 18.939826 ms in R
    info <- rbenchmark::benchmark(
        r1 <- opt_nlminb_julia(par0, "doubleLog_Beck", y, t, w),
        r2 <- opt_nlminb(par0, f_goal, fun = fun, y = y, t = t, pred = ypred),
        replications = 500
    )
    print(info)
}

}
}
\seealso{
\code{\link[stats:nlminb]{stats::nlminb()}}
}
