% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{textDistMatrix}
\alias{textDistMatrix}
\title{Calculate a Text Distance Matrix}
\usage{
textDistMatrix(M, zeroes = 0.5)
}
\arguments{
\item{M}{A numeric matrix}

\item{zeroes}{Text distance when both vectors are zero vectors; default is .5}
}
\value{
The text distance matrix with the text distance between all
combinations of the columns of \code{M}. This will give the same result as 
the function distMatrix when run with its default distance function 
"textDist"; however, for large matrices textDistMatrix is much more 
efficient. In addition, for very large matrices distMatrix may not run, 
while textDistMatrix will.
}
\description{
Calculate a distance matrix for a numeric matrix, using the textDist
function. It is used to calculate the text distance between all combinations 
of the columns of the matrix \code{M}.
}
\examples{
M=matrix(c(0,1,0,2,0,10,0,14,12,0,8,0,1,0,1,0),4)
colnames(M)=1:4;rownames(M)=c("A","B","C","D")
M
#Text distance matrix
textDistMatrix(M)
}
