% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{convertThickness}
\alias{convertThickness}
\title{Convert the "thickness" attribute of an existing filter_spct object.}
\usage{
convertThickness(x, thickness = NULL)
}
\arguments{
\item{x}{a filter_spct, object_spct, filter_mspct or object_mspct object.}

\item{thickness}{numeric [\eqn{m}].}
}
\value{
\code{x} possibly with the \code{"thickness"} field of the
  \code{"filter.properties"} attribute modified and \code{Tfr} or \code{A}
  computed for the requested thickness.
}
\description{
Function to set the "thickness" attribute and simultaneously converting the
spectral data to correspond to the new thickness.
}
\details{
For spectral transmittance at a different thickness to be exactly
  computed, it needs to be based on internal transmittance. This function
  will apply \code{converTfrType()} to \code{x} if needed, but to succeed
  metadata should be available. Please, see \code{\link{convertTfrType}}.
}
\note{
if \code{x} is not a \code{filter_spct}, \code{object_spct},
  \code{filter_mspct} or \code{object_mspct} object or a collection of such
  objects, \code{x} is returned unchanged. If \code{x} does not have the
  \code{"filter.properties"} attribute set or has it with missing member
  data, \code{x} is returned with \code{Tfr} set to \code{NA} values.
}
\examples{

my.spct <- polyester.spct
filter_properties(my.spct)
convertThickness(my.spct, thickness = 250e-6)

}
\seealso{
Other time attribute functions: 
\code{\link{checkTimeUnit}()},
\code{\link{convertTfrType}()},
\code{\link{convertTimeUnit}()},
\code{\link{getTimeUnit}()},
\code{\link{setTimeUnit}()}
}
\concept{time attribute functions}
