% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{T2Afr}
\alias{T2Afr}
\alias{T2Afr.default}
\alias{T2Afr.numeric}
\alias{T2Afr.filter_spct}
\alias{T2Afr.object_spct}
\alias{T2Afr.filter_mspct}
\alias{T2Afr.object_mspct}
\title{Convert transmittance into absorptance.}
\usage{
T2Afr(x, action, byref, clean, ...)

\method{T2Afr}{default}(x, action = NULL, byref = FALSE, clean = FALSE, ...)

\method{T2Afr}{numeric}(x, action = NULL, byref = FALSE, clean = FALSE, Rfr = NA_real_, ...)

\method{T2Afr}{filter_spct}(x, action = "add", byref = FALSE, clean = FALSE, ...)

\method{T2Afr}{object_spct}(x, action = "add", byref = FALSE, clean = FALSE, ...)

\method{T2Afr}{filter_mspct}(
  x,
  action = "add",
  byref = FALSE,
  clean = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{T2Afr}{object_mspct}(
  x,
  action = "add",
  byref = FALSE,
  clean = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object.}

\item{action}{character Allowed values \code{"replace"} and \code{"add"}.}

\item{byref}{logical indicating if new object will be created by reference
or by copy of \code{x}.}

\item{clean}{logical replace off-boundary values before conversion.}

\item{...}{not used in current version.}

\item{Rfr}{numeric vector. Spectral reflectance o reflectance factor.
Set to zero if \code{x} is internal reflectance,}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x} with a column \code{Afr} added and other columns
  possibly deleted except for \code{w.length}. If \code{action = "replace"},
  in all cases, the redundant columns are removed, even when
  column \code{Afr} was present in the argument passed to \code{x}.
}
\description{
Function that converts transmittance (fraction) into absorptance (fraction).
If reflectance (fraction) is available, it also allows conversions between
internal and total absorptance.
}
\details{
Absorptance, internal transmittance and total reflectance when expressed as
fractions, add up to one:

\deqn{1 = \alpha + \tau + \rho}

where, \eqn{\alpha} is absorptance, \eqn{\tau} is internal transmittance and
\eqn{\rho} is total reflectance. If any two of these quantities are known,
the third one can be computed from them.

On the other hand:

\deqn{1 = \alpha\prime + T}

where, \eqn{\alpha\prime = \alpha + \rho}, measured together. In this case,
there is not enough information available to compute \eqn{\alpha}.

Thus, method \code{T2Afr()} computes
either \eqn{\alpha} or \eqn{\alpha\prime},
depending on whether \eqn{\tau} or \eqn{T} are contained in the argument
passed to \code{x}, but neither of them when only \eqn{\tau} is known. To
know which quantity has been computed, use \code{getTfrType()} to query
whether the computations were based on \eqn{\tau} or \eqn{T}.

The R names used are: \code{Tfr} for \eqn{\tau} and \eqn{T} are \code{Tfr},
\code{Afr} for \eqn{\alpha} and \eqn{\alpha\prime}, and \code{Rfr} for
\eqn{rho}. The distinction between \eqn{\tau} and \eqn{T} and
between \eqn{\alpha} and \eqn{\alpha\prime} is made based on metadata
attributes.
}
\section{Methods (by class)}{
\itemize{
\item \code{T2Afr(default)}: Default method for generic function

\item \code{T2Afr(numeric)}: Default method for generic function

\item \code{T2Afr(filter_spct)}: Method for filter spectra

\item \code{T2Afr(object_spct)}: Method for object spectra

\item \code{T2Afr(filter_mspct)}: Method for collections of filter spectra

\item \code{T2Afr(object_mspct)}: Method for collections of object spectra

}}
\examples{
T2Afr(Ler_leaf.spct)

}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2A}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2q}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
