% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{fit_peaks}
\alias{fit_peaks}
\alias{fit_valleys}
\title{Refine position and value of extremes by fitting}
\usage{
fit_peaks(
  x,
  peaks.idx,
  span,
  x.col.name = NULL,
  y.col.name,
  method,
  max.span = 5L,
  maximum = TRUE,
  keep.cols = NULL
)

fit_valleys(
  x,
  valleys.idx,
  span,
  x.col.name = NULL,
  y.col.name,
  method,
  max.span = 5L,
  maximum = FALSE,
  keep.cols = NULL
)
}
\arguments{
\item{x}{generic_spct or data.frame object.}

\item{peaks.idx, valleys.idx}{logical or integer Indexes into \code{x}
selecting global or local extremes.}

\item{span}{odd integer The span used when refining the location of maxima or
minima of \code{x}.}

\item{x.col.name, y.col.name}{character Name of the column of \code{x} on
which to operate.}

\item{method}{character The method to use for the fit.}

\item{max.span}{odd integer The maximum number of data points used when
when refining the location of maxima and minima.}

\item{maximum}{logical A flag indicating whether to search for maxima or
minima.}

\item{keep.cols}{logical Keep unrecognized columns in data frames}
}
\value{
An R object of the same class as \code{x} containing the fitted
  values for the peaks, and optionally the values for at \code{peaks.idx} or
  \code{valleys.idx} for other retained columns.
}
\description{
Functions implementing fitting of peaks in a class-agnostic way. The fitting
refines the location of peaks and value of peaks based on the location of
maxima and minima supplied. This function is to be used together with
\code{find_peaks()} or \code{find_valleys()}.
}
\note{
These functions are not meant for everyday use. Use option
  \code{refine.wl = TRUE} of methods \code{peaks()} and \code{valleys()} instead.
}
\examples{

peaks <- find_peaks(sun.spct[["s.e.irrad"]], span = 31)
fit_peaks(sun.spct, peaks, span = 31,
          y.col.name = "s.e.irrad", method = "spline")

}
