% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setInstrSettings}
\alias{setInstrSettings}
\alias{instr_settings<-}
\title{Set the "instr.settings" attribute}
\usage{
setInstrSettings(x, instr.settings)

instr_settings(x) <- value
}
\arguments{
\item{x}{a \code{generic_spct} object or a \code{summary_generic_spct}
object.}

\item{instr.settings, value}{a \code{list} or a \code{instr_settings} object.}
}
\value{
x
}
\description{
Function to set by reference the \code{"what.measured"} attribute  of a
\code{generic_spct}, or of a \code{summary_generic_spct} object.
}
\details{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not a \code{generic_spct} object
  or a \code{summary_generic_spct} object, \code{x} is not modified,
  silently. If \code{inst.desc = NULL} is passed in the call, the attribute
  \code{instr.settings} is removed. \emph{This function is very rarely called
  from user code.}
}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
