% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{T2T}
\alias{T2T}
\alias{T2T.default}
\alias{T2T.filter_spct}
\alias{T2T.object_spct}
\alias{T2T.filter_mspct}
\alias{T2T.object_mspct}
\title{Convert transmittance type.}
\usage{
T2T(x, y, byref, Tfr.type.out, ...)

\method{T2T}{default}(x, y, byref = NULL, Tfr.type.out = NULL, ...)

\method{T2T}{filter_spct}(x, y, byref = FALSE, Tfr.type.out = "total", ...)

\method{T2T}{object_spct}(x, y = NULL, byref = FALSE, Tfr.type.out = "total", ...)

\method{T2T}{filter_mspct}(
  x,
  y,
  byref = FALSE,
  Tfr.type.out = "total",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{T2T}{object_mspct}(
  x,
  y,
  byref = FALSE,
  Tfr.type.out = "total",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x, y}{R objects}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{Tfr.type.out}{character One of "total" or "internal"}

\item{...}{not used in current version}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\description{
Function that allows conversion between internal and total transmittance.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{filter_spct}: Method for filter spectra

\item \code{object_spct}: Method for object spectra

\item \code{filter_mspct}: Method for collections of filter spectra

\item \code{object_mspct}: Method for collections of object spectra
}}

\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{e2q}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
