% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shenzhen-weili.r
\docType{data}
\name{leds_global}
\alias{leds_global}
\alias{shenzhen_weili}
\title{Spectral data for LEDs array supplied by Shenzhen Weili Optical}
\format{A vector of character strings.}
\usage{
leds_global
}
\description{
Datasets containing the wavelengths and tabulated values spectral emittance
for different light emitting diodes (LEDs) arrays from Shenzhen Weili Optical
Ltd.  Data are normalized to one at the wavelength of maximum emission.
}
\details{
The variables are as follows:
\itemize{
  \item w.length (nm)
  \item s.e.irrad (W m-2 nm-1)
}
}
\note{
Leds Global and Shenzhen Weili are trade names of the same supplier of LED
arrays. They sell both standard types and also assemble customized arrays
upon request. Customized arrays may have up to five independent channels.

\url{http://www.leds-global.com/}
}
\examples{
shenzhen_weili
leds_global
leds.mspct[leds_global]

}
\keyword{datasets}

