#' Spectral data for LEDs array supplied by Agilent/Hewlett Packard
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for light emitting diodes (LEDs) from Agilent/Hewlett Packard. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' hewlett_packard
#' 
#' @note
#' The division of Hewlett Packard which supplied these LEDs became part of
#' Agilent when this division spin-off the mother company. More recently
#' the electronic components division of Agilent became Avago Technologies
#' which still supplies some of these LEDs or similar improved types.
#' 
#' @references \url{https://www.broadcom.com/products/leds-and-displays/}
#' 
#' @seealso \code{\link{leds.mspct}}
#' 
#' @family manufacturers
#' 
"hewlett_packard"
