% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectbylocation.R
\name{selectbylocation}
\alias{selectbylocation}
\title{Select polygon features from another layer and adds polygon attributes to layer}
\usage{
selectbylocation(x, y)
}
\arguments{
\item{x}{source layer of the class SpatialPolygonsDataFrame or
SpatialPointsDataFrame}

\item{y}{Target layer or mask extent to subset from.}
}
\value{
A spatial polygons or spatial points object pruned to the extent
of the target layer.
}
\description{
The \code{selectbylocation} function selects features based on
their location relative to features in another layer.
}
\examples{
library(raster)
file <- system.file("nigeria/nigeria.rds", package = "phyloregion")
d <- readRDS(file)
e <- extent(d)

set.seed(1)
m <- data.frame(lon = runif(1000, e[1], e[2]),
  lat = runif(1000, e[3], e[4]),
  sites = seq(1000))
coordinates(m) <- ~ lon + lat
z <- selectbylocation(m, d)
plot(d)
points(m, col = "blue", pch = "+")
points(z, col = "red", pch = "+")
}
\keyword{bioregion}
