% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/phyloSim.R
\name{plot.phylosim}
\alias{plot.phylosim}
\title{Plot \code{phylosim} object}
\usage{
\method{plot}{phylosim}(x, what = c("stat", "pval"),
  stacked.methods = FALSE, quantiles = c(0.05, 0.95), col = 1:5,
  legend = TRUE, ...)
}
\arguments{
\item{x}{a \code{phylosim} object.}

\item{what}{what to represent on the plot.
Can be the statistics used to measure the signal ("\code{stat}") or the p-values ("\code{pval}").}

\item{stacked.methods}{a logical. If different methods have been used, should they
be plotted on the same graphic (\code{TRUE}) or not (\code{FALSE}, default).}

\item{quantiles}{a vector of two numeric values between 0 and 1
giving the minimum and the maximum quantiles to plot.
Set to \code{NULL} to not plot quantiles.}

\item{col}{a vector of colors for the different methods.}

\item{legend}{a logical. If \code{stacked.methods} is set to \code{TRUE},
should a legend be printed to differentiate the different methods?}

\item{...}{further arguments to be passed to or from other methods.}
}
\description{
This function plots a \code{phylosim} object to visualize the behaviour of
phylogenetic signal statistics for a given phylogenetic tree
}
\examples{
\dontrun{
data(navic)
psim <- phyloSim(navic)
plot(psim)
plot.phylosim(psim, what = "pval", stacked.methods = TRUE)
}
}
\seealso{
\code{\link{phyloSim}}.
}

