% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_kaggle}
\alias{board_register_kaggle}
\title{Register Kaggle Board}
\usage{
board_register_kaggle(
  name = "kaggle",
  token = NULL,
  overwrite = FALSE,
  cache = board_cache_path(),
  ...
)
}
\arguments{
\item{name}{Optional name for this board, defaults to 'kaggle'.}

\item{token}{The Kaggle token as a path to the \code{kaggle.json} file, can
be \code{NULL} if the \code{~/.kaggle/kaggle.json} file already exists.}

\item{overwrite}{Should \code{~/.kaggle/kaggle.json} be overriden?}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register Kaggle as a board.
}
\examples{
\dontrun{
# the following example requires a Kaggle API token
board_register_kaggle(token = "path/to/kaggle.json")
}

}
\seealso{
board_register
}
