% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_pir_out_to_long.R
\name{convert_pir_out_to_long}
\alias{convert_pir_out_to_long}
\title{Convert a \code{pir_out} to its long form}
\usage{
convert_pir_out_to_long(pir_out, verbose = FALSE)
}
\arguments{
\item{pir_out}{the output of \link{pir_run}}

\item{verbose}{if TRUE, show more output}
}
\value{
the \code{pir_out} in long form
}
\description{
A \code{pir_out} is a table with
columns \code{tree} (for true or twin tree), a column
\code{inference_model} (for generative or candidate) and columns named
\code{error_1}, \code{error_2}, etcetera, containing the inference errors.
}
\details{
Converting this to a long form, results in a tibble like this:

\enumerate{
  \item tree_and_model: either \code{true_generative},
    or \code{twin_generative}, or \code{true_candidate},
    or \code{twin_candidate}
  \item error_value: inference errors
}
}
\examples{
pir_out <- create_test_pir_run_output(
  add_twin = TRUE,
  add_best = TRUE
)
convert_pir_out_to_long(pir_out)
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
