% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtools-cache.R, R/rtools.R
\name{rtools_path}
\alias{rtools_path}
\alias{has_rtools}
\alias{find_rtools}
\alias{setup_rtools}
\alias{check_rtools}
\title{Is Rtools installed?}
\usage{
rtools_path()

has_rtools(debug = FALSE)

check_rtools(debug = FALSE)
}
\arguments{
\item{debug}{If \code{TRUE}, will print out extra information useful for
debugging. If \code{FALSE}, it will use result cached from a previous run.}
}
\value{
Either a visible \code{TRUE} if rtools is found, or an invisible
\code{FALSE} with a diagnostic \code{\link[=message]{message()}}.
As a side-effect the internal package variable \code{rtools_path} is
updated to the paths to rtools binaries.
}
\description{
To build binary packages on windows, Rtools (found at
\url{https://CRAN.R-project.org/bin/windows/Rtools/}) needs to be on
the path. The default installation process does not add it, so this
script finds it (looking first on the path, then in the registry).
It also checks that the version of rtools matches the version of R.
\code{has_rtools()} determines if Rtools is installed, caching the results.
Afterward, run \code{rtools_path()} to find out where it's installed.
}
\section{Acknowledgements}{

This code borrows heavily from RStudio's code for finding Rtools.
Thanks JJ!
}

\examples{
has_rtools()
}
\keyword{internal}
