% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{http_head}
\alias{http_head}
\title{Asynchronous HTTP HEAD request}
\usage{
http_head(url, headers = character(), file = NULL,
  options = list(timeout = 600), on_progress = NULL)
}
\arguments{
\item{url}{URL to connect to.}

\item{headers}{HTTP headers to send.}

\item{file}{If not \code{NULL}, it must be a string, specifying a file.
The body of the response is written to this file.}

\item{options}{Options to set on the handle. Passed to
\code{\link[curl:handle_setopt]{curl::handle_setopt()}}.}

\item{on_progress}{Progress handler function. It is only used if the
response body is written to a file. See details below.}
}
\value{
Deferred object.
}
\description{
Asynchronous HTTP HEAD request
}
\examples{
\donttest{
afun <- async(function() {
  dx <- http_head("https://eu.httpbin.org/status/200")$
    then(function(x) x$status_code)
})
synchronise(afun())

# Check a list of URLs in parallel
afun <- function(urls) {
  when_all(.list = lapply(urls, http_head))$
    then(function(x) lapply(x, "[[", "status_code"))
}
urls <- c("https://google.com", "https://eu.httpbin.org")
synchronise(afun(urls))
}
}
\seealso{
Other asyncronous HTTP calls: \code{\link{http_get}}
}
\concept{asyncronous HTTP calls}
