% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{when_some}
\alias{when_some}
\alias{when_any}
\title{Resolve a deferred as soon as some deferred from a list resolve}
\usage{
when_some(count, ..., .list = list())

when_any(..., .list = list())
}
\arguments{
\item{count}{Number of deferred values that need to resolve.}

\item{...}{Deferred values.}

\item{.list}{More deferred values.}
}
\value{
A deferred value, that is conditioned on all deferred values
in \code{...} and \code{.list}.
}
\description{
\code{when_some} creates a deferred value that is resolved as soon as the
specified number of deferred values resolve.
}
\details{
\code{when_any} is a special case for a single.

If the specified number of deferred values cannot be resolved, then
\code{when_any} throws an error.

async has auto-cancellation, so if the required number of deferred values
are resolved, or too many of them throw error, the rest of the are
cancelled.

If \code{when_any} throws an error, then all the underlying error objects
are returned in the \code{errors} member of the error object thrown by
\code{when_any}.
}
\examples{
\donttest{
## Use the URL that returns first
afun <- function() {
  u1 <- http_get("https://eu.httpbin.org")
  u2 <- http_get("https://eu.httpbin.org/get")
  when_any(u1, u2)$then(function(x) x$url)
}
synchronise(afun())
}
}
\seealso{
\code{\link[=when_all]{when_all()}}
}
