#' Build home page
#'
#' First looks for `index.Rmd` or `README.Rmd`, then
#' `index.md` or `README.md`. If none are found, falls back to the
#' description field in `DESCRIPTION`.
#'
#' @section Images and figures:
#' If you want to images in your `README.md`, they must be stored in
#' somewhere in the package so that they can be displayed on the CRAN
#' website. The best place to put them appears to be `man/figures`.
#' If you are generating figures with R Markdown, make sure you set up
#' `fig.path` as followed:
#'
#' \preformatted{
#' ```\{r, include = FALSE\}
#' knitr::opts_chunk$set(
#'   fig.path = "man/figures/"
#' )
#' ```
#' }
#'
#' @section YAML config:
#' To tweak the home page, you need a section called `home`.
#'
#' The sidebar links are automatically generated by inspecting the
#' `URL` and `BugReports` fields of the `DESCRIPTION`.
#' You can add additional links with a subsection called `links`,
#' which should contain a list of `text` + `href` elements:
#'
#' ```
#' home:
#'   links:
#'   - text: Link text
#'     href: http://website.com
#' ```
#'
#' The "developers" list is populated by the maintainer ("cre"), authors
#' ("aut"), and funder ("fnd").
#'
#' You can remove the first heading with
#'
#' ```
#' home:
#'   strip_header: true
#' ```
#'
#' @section Badges:
#' Status badges are displayed in the sidebar under the section "Dev status".
#' This section is automatically populated if the first paragraph of the
#' homepage consists solely of status badges as linked images.
#'
#' @inheritParams build_articles
#' @export
build_home <- function(pkg = ".",
                       override = list(),
                       preview = NA,
                       quiet = TRUE) {

  pkg <- section_init(pkg, depth = 0L, override = override)
  rule("Building home")
  dir_create(pkg$dst_path)

  if (has_citation(pkg$src_path)) {
    build_citation_authors(pkg)
  } else {
    build_authors(pkg)
  }
  build_home_md(pkg)
  build_home_license(pkg)
  build_home_index(pkg, quiet = quiet)

  preview_site(pkg, "/", preview = preview)
}
