% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-articles.R
\name{build_articles}
\alias{build_articles}
\alias{build_article}
\title{Build articles section}
\usage{
build_articles(pkg = ".", quiet = TRUE, lazy = TRUE,
  override = list(), preview = NA)

build_article(name, pkg = ".", data = list(), lazy = FALSE,
  quiet = TRUE)
}
\arguments{
\item{pkg}{Path to package.}

\item{quiet}{Set to \code{FALSE} to display output of knitr and
pandoc. This is useful when debugging.}

\item{lazy}{If \code{TRUE}, will only re-build article if input file has been
modified more recently than the output file.}

\item{override}{An optional named list used to temporarily override
values in \code{_pkgdown.yml}}

\item{preview}{If \code{TRUE}, or \code{is.na(preview) && interactive()}, will preview
freshly generated section in browser.}

\item{name}{Name of article to render. This should be either a path
relative to \code{vignettes/} without extension, or \code{index} or \code{README}.}

\item{data}{Additional data to pass on to template.}
}
\description{
Each R Markdown vignette in \code{vignettes/} and its subdirectories is rendered
and saved to \code{articles/}.

The only exception are \code{.Rmd} vignettes that start with \code{_} (i.e., \code{_index.Rmd}), enabling the use of child documents in \href{https://bookdown.org/yihui/bookdown/}{bookdown}, and vignettes in a \code{tutorials} subdirectory, which is reserved for tutorials built with \code{build_tutorials()}

Vignettes are rendered using a special document
format that reconciles \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}} with your pkgdown
template.

Note that when run by itself (i.e. not by \code{build_site()}), vignettes will
use a previous installed version of the package, not the current source
version.
}
\section{Get started vignette}{

A vignette with the same name as the package (e.g., \code{vignettes/pkgdown.Rmd})
gets special treatment. It is rendered and linked to in the navbar under
"Get started". Rmarkdown files in \code{vignettes/tutorials/} are ignored,
because these are assumed to contain tutorials, see \code{build_tutorials()}.
}

\section{External files}{

pkgdown differs from base R in its handling of external files. When building
vignettes, R assumes that vignettes are self-contained (a reasonable
assumption when most vignettes were PDFs) and only copies files explicitly
listed in \code{.install_extras}. pkgdown takes a different approach based on
\code{\link[rmarkdown:find_external_resources]{rmarkdown::find_external_resources()}}, and it will also copy any images that
you link to. If for some reason the automatic detection doesn't work, you
will need to add a \code{resource_files} field to the yaml metadata, e.g.:\preformatted{---
title: My Document
resource_files:
  - data/mydata.csv
  - images/figure.png
---
}

Note that you can not use the \code{fig.path} to change the output directory of
generated figures as its default value is a strong assumption of rmarkdown.
}

\section{Embedding Shiny apps}{

If you would like to embed a Shiny app into an article, the app will have
to be hosted independently, (e.g. \url{https://www.shinyapps.io}). Then, you
can embed the app into your article using an \code{<iframe>}, e.g.
\code{<iframe src = "https://gallery.shinyapps.io/083-front-page" class="shiny-app">}.

See \url{https://github.com/r-lib/pkgdown/issues/838#issuecomment-430473856} for
some hints on how to customise the appearance with CSS.
}

\section{YAML config}{

To tweak the index page, you need a section called \code{articles},
which provides a list of sections containing, a \code{title}, list of
\code{contents}, and optional \code{description}.

For example, this imaginary file describes some of the structure of
the \href{http://rmarkdown.rstudio.com/articles.html}{R markdown articles}:\preformatted{articles:
- title: R Markdown
  contents:
  - starts_with("authoring")
- title: Websites
  contents:
  - rmarkdown_websites
  - rmarkdown_site_generators
}

Note that \code{contents} can contain either a list of vignette names
(including subdirectories), or if the functions in a section share a
common prefix or suffix, you can use \code{starts_with("prefix")} and
\code{ends_with("suffix")} to select them all. If you don't care about
position within the string, use \code{contains("word")}. For more complex
naming schemes you can use an arbitrary regular expression with
\code{matches("regexp")}.

pkgdown will check that all vignettes are included in the index
this page, and will generate a warning if you have missed any.
}

\section{YAML header}{

By default, pkgdown builds all articles with \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}
by setting the \code{template} parameter. This overrides any custom settings
you have in your YAML metadata, ensuring that all articles are rendered
in the same way (and receive the default site template).

If you need to override the output format, or set any options, you'll need
to add a \code{pkgdown} field to your yaml metadata:\preformatted{pkgdown:
  as_is: true
}

This will tell pkgdown to use the \code{output_format} (and options) that you
have specified. This format must accept \code{template}, \code{theme}, and
\code{self_contained} in order to work with pkgdown.

If the output format produces a PDF, you'll also need to specify the
\code{extension} field:\preformatted{pkgdown:
  as_is: true
  extension: pdf
}
}

\section{Suppressing vignettes}{

If you want articles that are not vignettes, either put them in
subdirectories or list in \code{.Rbuildignore}. An articles link will be
automatically added to the default navbar if the vignettes directory is
present: if you do not want this, you will need to customise the navbar. See
\code{\link[=build_site]{build_site()}} details.

Vignette files prefixed with an underscore (e.g., \code{_index.Rmd}) are ignored
to enable rendering of \href{https://bookdown.org/yihui/bookdown/}{bookdown}
sites.
}

\section{Tables of contents}{

You can control the TOC depth via the YAML configuration file:\preformatted{toc:
  depth: 2
}
}

\section{Figures}{


You can control the default rendering of figures by specifying the \code{figures}
field in \code{_pkgdown.yml}. The default settings are equivalent to:\preformatted{figures:
  dev: grDevices::png
  dpi: 96
  dev.args: []
  fig.ext: png
  fig.width: 7.2916667
  fig.height: ~
  fig.retina: 2
  fig.asp: 1.618
}
}

