
<!-- README.md is generated from README.Rmd. Please edit that file -->

# planr <img src="man/figures/logo.png" align="right" height="200"/>

The goal of planr is to provide some functions for the activity of
Demand & Supply Planning and S&OP process:

-   to calculate projected inventories and coverages :
    **light_proj_inv()**

-   to calculate and analyze projected inventories and coverages :
    **proj_inv()**

-   to calculate a Replenishment Plan (also called DRP : Distribution
    Requirement Planning) : **drp()**

## Installation

You can install the development version of planr through GitHub:

``` r
library(devtools)
install_github("nguyennico/planr")

library(planr)
```

## How to use

Please refer to the sections:

-   Get Started

-   See some examples of applications

## Links

-   R Views: [Using R in Inventory Management and Demand
    Forecasting](https://rviews.rstudio.com/2022/10/20/projected-inventory-calculations-using-r-1/)

-   Posit / RStudio Data Science Meetup : [Supply Chain
    Management](https://www.youtube.com/watch?v=rzs6aSr4XoU)

-   R Shiny app demo for projected inventories : [example of shiny app
    using the planr
    package](https://niconguyen.shinyapps.io/Projected_Inventories/)

-   ASCM : [S&OP and the Digital Supply Chain, using R &
    Python](https://www.ascm.org/ascm-insights/sop-and-the-digital-supply-chain/)

-   RPubs : [Demand and Supply Planning with
    R](https://rpubs.com/nikonguyen/972907)
