% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fitaci.R, R/fitacis.R
\name{fitaci}
\alias{coef.acifit}
\alias{coef.acifits}
\alias{fitaci}
\alias{fitacis}
\alias{fitted.acifit}
\alias{plot.acifit}
\alias{plot.acifits}
\alias{print.acifit}
\alias{summary.acifit}
\title{Fit the Farquhar-Berry-von Caemmerer model of leaf photosynthesis}
\usage{
fitaci(data, varnames = list(ALEAF = "Photo", Tleaf = "Tleaf", Ci = "Ci", PPFD
  = "PARi"), Tcorrect = TRUE, citransition = NULL, quiet = FALSE,
  startValgrid = TRUE, algorithm = "default", ...)

\method{print}{acifit}(x, ...)

\method{summary}{acifit}(object, ...)

\method{coef}{acifit}(object, ...)

\method{fitted}{acifit}(object, ...)

\method{plot}{acifit}(x, what = c("data", "model"), xlim = NULL,
  ylim = NULL, whichA = c("Ac", "Aj", "Amin"), add = FALSE, pch = 19,
  addzeroline = TRUE, addlegend = !add, transitionpoint = TRUE,
  lwd = c(1, 2), ...)

fitacis(data, group, progressbar = TRUE, quiet = FALSE, ...)

\method{plot}{acifits}(x, how = c("manyplots", "oneplot"), ...)

\method{coef}{acifits}(object, ...)
}
\arguments{
\item{data}{Dataframe with Ci, Photo, Tleaf, PPFD (the last two are optional). For \code{fitacis}, also requires a grouping variable.}

\item{varnames}{List of names of variables in the dataset (see Details).}

\item{Tcorrect}{If TRUE, Vcmax and Jmax are corrected to 25C. Otherwise, Vcmax and Jmax are estimated at measurement temperature.}

\item{citransition}{If provided, fits the Vcmax and Jmax limited regions separately (see Details).}

\item{quiet}{If TRUE, no messages are written to the screen.}

\item{startValgrid}{If TRUE (the default), uses a fine grid of starting values to increase the chance of finding a solution.}

\item{algorithm}{Passed to \code{\link{nls}}, sets the algorithm for finding parameter values.}

\item{x}{For plot.acifit, an object returned by \code{fitaci}}

\item{object}{For coef.acifit, and print.acifit, the object returned by \code{fitaci}}

\item{what}{The default is to plot both the data and the model fit, or specify 'data' or 'model' to plot one of them.}

\item{xlim}{Limits for the X axis, if left blank estimated from data}

\item{ylim}{Limits for the Y axis, if left blank estimated from data}

\item{whichA}{By default all three photosynthetic rates are plotted (Aj=Jmax-limited (blue), Ac=Vcmax-limited (red), Hyperbolic minimum (black)). Or, specify one or two of them.}

\item{add}{If TRUE, adds to the current plot}

\item{pch}{The plotting symbol for the data}

\item{addzeroline}{If TRUE, the default, adds a dashed line at y=0}

\item{addlegend}{If TRUE, adds a legend (by default does not add a legend if add=TRUE)}

\item{transitionpoint}{For plot.acifit, whether to plot a symbol at the transition point.}

\item{lwd}{Line widths, can be a vector of length 2 (first element for both rates, second one for the limiting rate).}

\item{group}{For batch analysis using \code{fitacis}, the name of the grouping variable in the dataframe.}

\item{progressbar}{For \code{fitacis}, whether to display a progress bar (default is TRUE).}

\item{how}{If 'manyplots', produces a single plot for each A-Ci curve. If 'oneplot' overlays all of them.}

\item{\dots}{Further arguments passed to \code{\link{Photosyn}}}
}
\value{
A list of class 'acifit', with five components:
\describe{
\item{df}{A dataframe with the original data, the fitted photosynthetic rate (Amodel), Jmax and Vcmax-limited gross rates (Aj, Ac)}
\item{pars}{Contains the parameter estimates and their approximate standard errors}
\item{nlsfit}{The object returned by \code{\link{nls}}, and contains more detail on the quality of the fit}
\item{Photosyn}{A copy of the \code{\link{Photosyn}} function with the arguments adjusted for the current fit. That is, Vcmax, Jmax and Rd are set to those estimated in the fit, and Tleaf and PPFD are set to the mean value in the dataset.}
\item{Ci_transition}{The Ci at which photosynthesis transitions from Vcmax to Jmax limited photosynthesis.}
}
}
\description{
Fits the Farquhar-Berry-von Caemmerer model of photosynthesis to measurements of photosynthesis and intercellular \eqn{CO_2}{CO2} concentration (Ci). Estimates Jmax, Vcmax, Rd and their standard errors. A simple plotting method is also included, as well as the function \code{\link{fitacis}} which quickly fits multiple A-Ci curves. Temperature dependencies are taken into account, see \code{\link{Photosyn}}.
}
\details{
Uses non-linear regression to fit an A-Ci curve. No assumptions are made on which part of the curve is Vcmax or Jmax limited. Three parameters are estimated, Jmax, Vcmax and Rd. When \code{Tcorrect=TRUE} (the defualt), Jmax and Vcmax are re-scaled to 25C, using the temperature response parameters provided (but Rd is always at measurement temperature). When \code{Tcorrect=FALSE}, estimates of all parameters are at measurement temperature.

When \code{citransition} is set, it splits the data into a Vcmax-limited (where Ci < citransition), and Jmax-limited region (Ci > citransition). Both parameters are then estimated separately for each region (Rd is estimated only for the Vcmax-limited region). \bold{Note} that the actual transition point as shown in the standard plot of the fitted A-Ci curve may be quite different from that provided, since the fitting method simply decides which part of the dataset to use for which limitation, it does not constrain the actual estimated transition point directly. See the example below.

When plotting the fit, the A-Ci curve is simulated using the \code{\link{Aci}} function, with leaf temperature (Tleaf) and PPFD set to the mean value for the dataset. If PPFD is not provided in the dataset, it is assumed to equal 1800 mu mol m-2 s-1.
}
\examples{
# Fit an A-Ci curve on a dataframe that contains Ci, Photo and optionally Tleaf and PPFD.
# Here, we use the built-in example dataset 'acidata1'.
f <- fitaci(acidata1)

# Note that the default behaviour is to correct Vcmax and Jmax for temperature,
# so the estimated values are at 25C. To turn this off:
f2 <- fitaci(acidata1, Tcorrect=FALSE)

# To use different T response parameters (see ?Photosyn),
f3 <- fitaci(acidata1, Tcorrect=TRUE, EaV=25000)

# Make a standard plot
plot(f)

# Look at a summary of the fit
summary(f)

# Extract coefficients only
coef(f)

# The object 'f' also contains the original data with predictions.
# Here, Amodel are the modelled (fitted) values, Ameas are the measured values.
with(f$df, plot(Amodel, Ameas))
abline(0,1)

# The fitted values can also be extracted with the fitted() function:
fitted(f)

# The non-linear regression (nls) fit is stored as well,
summary(f$nlsfit)

# The curve generator is stored as f$Photosyn:
# Calculate photosynthesis at some value for Ci, using estimated parameters and mean Tleaf,
# PPFD for the dataset.
f$Photosyn(Ci=820)

# Photosynthetic rate at the transition point:
f$Photosyn(Ci=f$Ci_transition)$ALEAF

# Set the transition point; this will fit Vcmax and Jmax separately. Note that the *actual*
# transition is quite different from that provided, this is perfectly fine :
# in this case Jmax is estimated from the latter 3 points only (Ci>800), but the actual
# transition point is at ca. 400ppm.
g <- fitaci(acidata1, citransition=800)
plot(g)
g$Ci_transition
}

