% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScaleItem.R
\name{ScaleItem}
\alias{ScaleItem}
\title{Re-scales the category scale values and Phi after convergence of nominal model}
\usage{
ScaleItem(
  item.log,
  Phi.mat,
  anchor,
  item.by.trait,
  nitems,
  ncat,
  nless,
  ntraits,
  ItemNames
)
}
\arguments{
\item{item.log}{Log history of parameter estimates at each iteration}

\item{Phi.mat}{Final estimate of the phi matrix}

\item{anchor}{Indicator of item(s) to place scaling constraint on.}

\item{item.by.trait}{Index for which trait item loads on}

\item{nitems}{Number of items}

\item{ncat}{Number of categories per item}

\item{nless}{Number of unique lambdas &  unique nus}

\item{ntraits}{Number of latent traits}

\item{ItemNames}{Item names}
}
\value{
sNu         	Re-scaled category scale values

sPhi.mat	  	Re-scale phi matrix (conditional covariance matrix)
}
\description{
The function only applies to nominal models.  During estimation, a scaling
constraint is put on conditional variances such that they are equal to 1.
This function provide an alternative identification constraints that can be
used after the algorithm has converged. This function allow a user to tease
apart the strength and structure of associations.  The common alternative is
to constrain the sum of category scale values equals 0 and the sum of squares
equals 1. The phi parameters are adjusted accordingly and is now a
conditional covariance matrix. One item per trait needs to be selected for ID
constraint and this is indicated by the object anchor. This function is
designed for nominal models.
}
