% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan.R
\name{Plan}
\alias{Plan}
\title{R6 Class representing a Plan}
\description{
We work within the mental model where we have one (or more) datasets and we want to run multiple analyses on these datasets.

By demanding that all analyses use the same data sources we can:
\itemize{
\item Be efficient with requiring the minimal amount of data-pulling (this only happens once at the start).
\item Better enforce the concept that data-cleaning and analysis should be completely separate.
}

By demanding that all analysis functions only use two arguments (data and argset) we can:
\itemize{
\item Reduce mental fatigue by working within the same mental model for each analysis.
\item Make it easier for analyses to be exchanged with each other and iterated on.
\item Easily schedule the running of each analysis.
}

By including all of this in one \code{Plan} class, we can easily maintain a good overview of all the analyses (i.e. outputs) that need to be run.
}
\details{
An argset is:
\itemize{
\item a set of arguments
}

An analysis is:
\itemize{
\item one argset
\item one (action) function
}

A plan is:
\itemize{
\item one data pull
\item a list of analyses
}
}
\examples{

## ------------------------------------------------
## Method `Plan$add_data`
## ------------------------------------------------

p <- plnr::Plan$new()
data_fn <- function(){return(plnr::norway_covid19_cases_by_time_location)}
p$add_data("data_1", fn = data_fn)
p$add_data("data_2", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$add_data("data_3", direct = plnr::norway_covid19_cases_by_time_location)
p$get_data()

## ------------------------------------------------
## Method `Plan$add_argset`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_argset("argset_1", var_1 = 3, var_b = "hello")
p$add_argset("argset_2", var_1 = 8, var_c = "hello2")
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_argset_from_df`
## ------------------------------------------------

p <- plnr::Plan$new()
batch_argset_df <- data.frame(name = c("a", "b", "c"), var_1 = c(1, 2, 3), var_2 = c("i", "j", "k"))
p$add_argset_from_df(batch_argset_df)
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_argset_from_list`
## ------------------------------------------------

p <- plnr::Plan$new()
batch_argset_list <- list(
  list(name = "a", var_1 = 1, var_2 = "i"),
  list(name = "b", var_1 = 2, var_2 = "j"),
  list(name = "c", var_1 = 3, var_2 = "k")
)
p$add_argset_from_list(batch_argset_list)
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$add_analysis`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$add_analysis(
  name = "analysis_1",
  fn_name = "plnr::example_action_fn"
)
p$get_argsets_as_dt()
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$add_analysis_from_df`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_df <- data.frame(name = c("a", "b", "c"), var_1 = c(1, 2, 3), var_2 = c("i", "j", "k"))
p$add_analysis_from_df(
  fn_name = "plnr::example_action_fn",
  df = batch_argset_df
 )
p$get_argsets_as_dt()
p$run_one(1)

## ------------------------------------------------
## Method `Plan$add_analysis_from_list`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$get_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$get_data()

## ------------------------------------------------
## Method `Plan$get_analysis`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_analysis("analysis_1")

## ------------------------------------------------
## Method `Plan$get_argset`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argset("analysis_1")

## ------------------------------------------------
## Method `Plan$get_argsets_as_dt`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()

## ------------------------------------------------
## Method `Plan$run_one_with_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_one_with_data("analysis_1", data)

## ------------------------------------------------
## Method `Plan$run_one`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_one("analysis_1")

## ------------------------------------------------
## Method `Plan$run_all_with_data`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_all_with_data(data)

## ------------------------------------------------
## Method `Plan$run_all`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all()

## ------------------------------------------------
## Method `Plan$run_all_progress`
## ------------------------------------------------

p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all_progress()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{analyses}}{List of analyses.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Plan$new()}}
\item \href{#method-add_data}{\code{Plan$add_data()}}
\item \href{#method-add_argset}{\code{Plan$add_argset()}}
\item \href{#method-add_argset_from_df}{\code{Plan$add_argset_from_df()}}
\item \href{#method-add_argset_from_list}{\code{Plan$add_argset_from_list()}}
\item \href{#method-add_analysis}{\code{Plan$add_analysis()}}
\item \href{#method-add_analysis_from_df}{\code{Plan$add_analysis_from_df()}}
\item \href{#method-add_analysis_from_list}{\code{Plan$add_analysis_from_list()}}
\item \href{#method-apply_action_fn_to_all_argsets}{\code{Plan$apply_action_fn_to_all_argsets()}}
\item \href{#method-apply_analysis_fn_to_all}{\code{Plan$apply_analysis_fn_to_all()}}
\item \href{#method-x_length}{\code{Plan$x_length()}}
\item \href{#method-x_seq_along}{\code{Plan$x_seq_along()}}
\item \href{#method-set_progress}{\code{Plan$set_progress()}}
\item \href{#method-set_progressor}{\code{Plan$set_progressor()}}
\item \href{#method-set_verbose}{\code{Plan$set_verbose()}}
\item \href{#method-set_use_foreach}{\code{Plan$set_use_foreach()}}
\item \href{#method-get_data}{\code{Plan$get_data()}}
\item \href{#method-get_analysis}{\code{Plan$get_analysis()}}
\item \href{#method-get_argset}{\code{Plan$get_argset()}}
\item \href{#method-get_argsets_as_dt}{\code{Plan$get_argsets_as_dt()}}
\item \href{#method-run_one_with_data}{\code{Plan$run_one_with_data()}}
\item \href{#method-run_one}{\code{Plan$run_one()}}
\item \href{#method-run_all_with_data}{\code{Plan$run_all_with_data()}}
\item \href{#method-run_all}{\code{Plan$run_all()}}
\item \href{#method-run_all_progress}{\code{Plan$run_all_progress()}}
\item \href{#method-clone}{\code{Plan$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Plan instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$new(verbose = interactive() | config$force_verbose, use_foreach = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Should this plan be verbose?}

\item{\code{use_foreach}}{???}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-add_data}{}}}
\subsection{Method \code{add_data()}}{
Add a new data set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_data(name, fn = NULL, fn_name = NULL, direct = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the data set.}

\item{\code{fn}}{A function that returns the data set.}

\item{\code{fn_name}}{A character string containing the name of a function that returns the data set.}

\item{\code{direct}}{A direct data set.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
data_fn <- function(){return(plnr::norway_covid19_cases_by_time_location)}
p$add_data("data_1", fn = data_fn)
p$add_data("data_2", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$add_data("data_3", direct = plnr::norway_covid19_cases_by_time_location)
p$get_data()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_argset"></a>}}
\if{latex}{\out{\hypertarget{method-add_argset}{}}}
\subsection{Method \code{add_argset()}}{
Add a new argset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset(name = uuid::UUIDgenerate(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the (eventual) analysis that this argset will be connected to.}

\item{\code{...}}{Named arguments that will comprise the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_argset("argset_1", var_1 = 3, var_b = "hello")
p$add_argset("argset_2", var_1 = 8, var_c = "hello2")
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_argset_from_df"></a>}}
\if{latex}{\out{\hypertarget{method-add_argset_from_df}{}}}
\subsection{Method \code{add_argset_from_df()}}{
Add a batch of argsets from a data.frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset_from_df(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{A data.frame where each row is a new argset, and each column will be a named element in the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
batch_argset_df <- data.frame(name = c("a", "b", "c"), var_1 = c(1, 2, 3), var_2 = c("i", "j", "k"))
p$add_argset_from_df(batch_argset_df)
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_argset_from_list"></a>}}
\if{latex}{\out{\hypertarget{method-add_argset_from_list}{}}}
\subsection{Method \code{add_argset_from_list()}}{
Add a batch of argsets from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_argset_from_list(l)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{l}}{A list of lists with named elements where each outermost element is a new argset, and each internal named element named element in the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
batch_argset_list <- list(
  list(name = "a", var_1 = 1, var_2 = "i"),
  list(name = "b", var_1 = 2, var_2 = "j"),
  list(name = "c", var_1 = 3, var_2 = "k")
)
p$add_argset_from_list(batch_argset_list)
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-add_analysis}{}}}
\subsection{Method \code{add_analysis()}}{
Add a new analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis(name = uuid::UUIDgenerate(), fn = NULL, fn_name = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the analysis.}

\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.}

\item{\code{...}}{Named arguments to be added to the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$add_analysis(
  name = "analysis_1",
  fn_name = "plnr::example_action_fn"
)
p$get_argsets_as_dt()
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_analysis_from_df"></a>}}
\if{latex}{\out{\hypertarget{method-add_analysis_from_df}{}}}
\subsection{Method \code{add_analysis_from_df()}}{
Add a batch of analyses from a data.frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis_from_df(fn = NULL, fn_name = NULL, df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.}

\item{\code{df}}{A data.frame where each row is a new argset, and each column will be a named element in the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_df <- data.frame(name = c("a", "b", "c"), var_1 = c(1, 2, 3), var_2 = c("i", "j", "k"))
p$add_analysis_from_df(
  fn_name = "plnr::example_action_fn",
  df = batch_argset_df
 )
p$get_argsets_as_dt()
p$run_one(1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_analysis_from_list"></a>}}
\if{latex}{\out{\hypertarget{method-add_analysis_from_list}{}}}
\subsection{Method \code{add_analysis_from_list()}}{
Add a batch of argsets from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$add_analysis_from_list(fn = NULL, fn_name = NULL, l)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.}

\item{\code{l}}{A list of lists with named elements where each outermost element is a new argset, and each internal named element named element in the argset.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply_action_fn_to_all_argsets"></a>}}
\if{latex}{\out{\hypertarget{method-apply_action_fn_to_all_argsets}{}}}
\subsection{Method \code{apply_action_fn_to_all_argsets()}}{
Applies an action function to all the argsets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$apply_action_fn_to_all_argsets(fn = NULL, fn_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.
p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
list(name = "analysis_1", var_1 = 1, var_2 = "i"),
list(name = "analysis_2", var_1 = 2, var_2 = "j"),
list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_argset_from_list(
fn_name = "plnr::example_action_fn",
l = batch_argset_list
)
p$get_argsets_as_dt()
p$apply_action_fn_to_all_argsets(fn_name = "plnr::example_action_fn")
p$run_one("analysis_1")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply_analysis_fn_to_all"></a>}}
\if{latex}{\out{\hypertarget{method-apply_analysis_fn_to_all}{}}}
\subsection{Method \code{apply_analysis_fn_to_all()}}{
Deprecated. Use apply_action_fn_to_all_argsets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$apply_analysis_fn_to_all(fn = NULL, fn_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Action function.}

\item{\code{fn_name}}{Action function name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-x_length"></a>}}
\if{latex}{\out{\hypertarget{method-x_length}{}}}
\subsection{Method \code{x_length()}}{
Number of analyses in the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$x_length()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-x_seq_along"></a>}}
\if{latex}{\out{\hypertarget{method-x_seq_along}{}}}
\subsection{Method \code{x_seq_along()}}{
Generate a regular sequence from 1 to the length of the analyses in the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$x_seq_along()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_progress"></a>}}
\if{latex}{\out{\hypertarget{method-set_progress}{}}}
\subsection{Method \code{set_progress()}}{
Set an internal progress bar
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_progress(pb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pb}}{Progress bar.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_progressor"></a>}}
\if{latex}{\out{\hypertarget{method-set_progressor}{}}}
\subsection{Method \code{set_progressor()}}{
Set an internal progressor progress bar
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_progressor(pb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pb}}{progressor progress bar.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_verbose"></a>}}
\if{latex}{\out{\hypertarget{method-set_verbose}{}}}
\subsection{Method \code{set_verbose()}}{
Set verbose flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_verbose(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Boolean.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_use_foreach"></a>}}
\if{latex}{\out{\hypertarget{method-set_use_foreach}{}}}
\subsection{Method \code{set_use_foreach()}}{
Set use_foreach flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$set_use_foreach(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Boolean.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-get_data}{}}}
\subsection{Method \code{get_data()}}{
Extracts the data provided via 'add_data' and returns it as a named list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named list, where most elements have been added via \code{add_data}.

One extra named element is called 'hash'. 'hash' contains the data hashes of particular datasets/variables, as calculated using the 'spookyhash' algorithm via digest::digest.
'hash' contains two named elements:
\itemize{
\item current (the hash of the entire named list)
\item current_elements (the hash of the named elements within the named list)
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
p$get_data()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_analysis"></a>}}
\if{latex}{\out{\hypertarget{method-get_analysis}{}}}
\subsection{Method \code{get_analysis()}}{
Extracts an analysis from the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_analysis(index_analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An analysis.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_analysis("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_argset"></a>}}
\if{latex}{\out{\hypertarget{method-get_argset}{}}}
\subsection{Method \code{get_argset()}}{
Extracts an argset from the plan.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_argset(index_analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An argset
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argset("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_argsets_as_dt"></a>}}
\if{latex}{\out{\hypertarget{method-get_argsets_as_dt}{}}}
\subsection{Method \code{get_argsets_as_dt()}}{
Gets all argsets and presents them as a data.table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$get_argsets_as_dt()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data.table that contains all the argsets within a plan.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$get_argsets_as_dt()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_one_with_data"></a>}}
\if{latex}{\out{\hypertarget{method-run_one_with_data}{}}}
\subsection{Method \code{run_one_with_data()}}{
Run one analysis (data is provided by user).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_one_with_data(index_analysis, data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}

\item{\code{data}}{Named list (generally obtained from p$get_data()).}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_one_with_data("analysis_1", data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_one"></a>}}
\if{latex}{\out{\hypertarget{method-run_one}{}}}
\subsection{Method \code{run_one()}}{
Run one analysis (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_one(index_analysis, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index_analysis}}{Either an integer (1:length(analyses)) or a character string representing the name of the analysis.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_one("analysis_1")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_all_with_data"></a>}}
\if{latex}{\out{\hypertarget{method-run_all_with_data}{}}}
\subsection{Method \code{run_all_with_data()}}{
Run all analyses (data is provided by user).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all_with_data(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Named list (generally obtained from p$get_data()).}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
data <- p$get_data()
p$run_all_with_data(data)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_all"></a>}}
\if{latex}{\out{\hypertarget{method-run_all}{}}}
\subsection{Method \code{run_all()}}{
Run all analyses (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_all_progress"></a>}}
\if{latex}{\out{\hypertarget{method-run_all_progress}{}}}
\subsection{Method \code{run_all_progress()}}{
Run all analyses with a progress bar (data is obtained automatically from self$get_data()).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$run_all_progress(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List where each element contains the returned value from the action function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{p <- plnr::Plan$new()
p$add_data("covid_data", fn_name = "plnr::example_data_fn_norway_covid19_cases_by_time_location")
batch_argset_list <- list(
  list(name = "analysis_1", var_1 = 1, var_2 = "i"),
  list(name = "analysis_2", var_1 = 2, var_2 = "j"),
  list(name = "analysis_3", var_1 = 3, var_2 = "k")
)
p$add_analysis_from_list(
  fn_name = "plnr::example_action_fn",
  l = batch_argset_list
)
p$run_all_progress()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Plan$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
