% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.loadings.R
\name{plot.loadings}
\alias{plot.loadings}
\title{plot.loadings}
\usage{
\method{plot}{loadings}(x, reorder = TRUE, ...)
}
\arguments{
\item{x}{matrix: loadings}

\item{reorder}{locgical: if the rows (variables) of the loading matrix should be reordered (default: \code{TRUE})}

\item{...}{further parameter given to the \code{\link{plot.matrix}} command}
}
\value{
a plot
}
\description{
Visualizes the loadings matrix from a Factor Analysis or a Principal Component Analysis matrix 
with a colored heatmap. You may need to modify \code{mar} with the \code{\link[graphics]{par}} command from its default \code{c(5.1,4.1,4.1,2.1)}.
See
\itemize{
\item \code{vignette('plot.matrix')} for detailed examples, and
\item \code{\link{plot.matrix}} for further parameters.
}
}
\examples{
library("psych")
data <- na.omit(bfi[,1:25])
par(mar=c(5.1, 4.1, 4.1, 4.1))
# Factor analysis
fa <- factanal(data, 5)
plot(loadings(fa))
# Principal Component Analysis I
pa <- princomp(data)
plot(loadings(pa), digits=NA)
# Principal Component Analysis II
pa <- prcomp(data)
ld <- structure(pa$rotation, class="loadings") 
plot(ld, digits=NA)
}
