% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.loadings.R
\name{plot.loadings}
\alias{plot.loadings}
\title{plot.loadings}
\usage{
\method{plot}{loadings}(x, reorder = TRUE, gray = FALSE,
  grey = FALSE, ...)
}
\arguments{
\item{x}{matrix: loadings}

\item{reorder}{logical: if the rows (variables) of the loading matrix should be reordered (default: \code{TRUE})}

\item{gray}{logical: should be a gray scale color palette used or not (default: \code{FALSE})}

\item{grey}{logical: should be a gray scale color palette used or not (default: \code{FALSE})}

\item{...}{further parameter given to the \code{\link{plot.matrix}} command}
}
\value{
a plot
}
\description{
Visualizes the loadings matrix from a Factor Analysis or a Principal Component Analysis matrix 
with a gray or colored heatmap. As a rule of thumb the breaks are determined by 
\code{c(-1, -0.866, -0.707, -0.5, -0.4, 0, +0.4, +0.5, +0.707, +0.866, +1)} is used.
You may need to modify \code{mar} with the \code{\link[graphics]{par}} command from its default 
\code{c(5.1,4.1,4.1,2.1)}.
See
\itemize{
\item \code{vignette('plot.matrix')} for detailed examples, and
\item \code{\link{plot.matrix}} for further parameters.
}
}
\details{
If either the parameter \code{grey} or \code{gray} is \code{TRUE} then a gray color palette is used.
}
\examples{
data(bfi.2)
library("psych")
par(mar=c(5.1, 4.1, 4.1, 4.1))
# Factor analysis
fa <- factanal(bfi.2, 5)
plot(loadings(fa))
plot(loadings(fa), grey=TRUE)
# Principal Component Analysis I
pa <- princomp(bfi.2)
plot(loadings(pa), digits=NA)
# Principal Component Analysis II
pa <- prcomp(bfi.2)
ld <- structure(pa$rotation, class="loadings") 
plot(ld, digits=NA)
}
