% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ternary.R
\name{TernaryField}
\alias{TernaryField}
\title{Draw a field on an existing ternary plot}
\usage{
TernaryField(field, ..., length = 0.05)
}
\arguments{
\item{field}{object of class \code{field3logit} as returned by
\code{\link{field3logit}}.}

\item{...}{\link{graphical parameters} such as \code{xpd} and the line
    characteristics \code{lend}, \code{ljoin} and \code{lmitre}:
    see \code{\link{par}}.}

\item{length}{length of the edges of the arrow head (in inches).}
}
\value{
Argument \code{field} is invisibly returned.
}
\description{
\code{TernaryField} adds to an existing ternary plot generated by
\code{\link[Ternary:TernaryPlot]{TernaryPlot}} the vector field returned by
\code{\link{field3logit}}.
}
\examples{
library(nnet)
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale')

TernaryPlot()
TernaryField(field0)

}
\seealso{
\code{\link{field3logit}}.
}
