% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdelta.R
\name{get_vdelta}
\alias{get_vdelta}
\title{It computes the vector of covariate change}
\usage{
get_vdelta(delta, model)
}
\arguments{
\item{delta}{see \code{\link{field3logit}}.}

\item{model}{object returned by \code{\link{read_model}}.}
}
\value{
\code{numeric} vector of covariate change \eqn{\Delta\in\textbf{R}^k}.
}
\description{
Given the argument \code{delta} passed to \code{\link{field3logit}} either as
a \code{numeric} vector, a \code{character} or an \code{expression} (see
\code{\link{field3logit}}), \code{get_vdelta} returns the \code{numeric} vector of
covariate change \eqn{\Delta\in\textbf{R}^k}.
}
\examples{
library(magrittr)

# Example 1
matrix(c(0.11, 0.07, -0.1, 0.09), 2) \%>\%
  plot3logit:::read_model('logit', NULL) \%>\%
  plot3logit:::get_vdelta(c(0, 1), .)

# Example 2
library(nnet)
data(cross_1year)
mod0 <- multinom(employment_sit ~ ., cross_1year)
plot3logit:::read_model(mod0, 'logit', NULL) \%>\%
  plot3logit:::get_vdelta('genderFemale', .)

# Example 3
plot3logit:::read_model(mod0, 'logit', NULL) \%>\%
  plot3logit:::get_vdelta('-0.5 * genderFemale + hsscore', .)

}
\keyword{internal}
