% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tabledap.R
\name{add_tabledap}
\alias{add_tabledap}
\title{Add rerddap::tabledap data to a plotdap map}
\usage{
add_tabledap(plot, table, var, color = c("#132B43", "#56B1F7"),
  size = 1.5, shape = 19, animate = FALSE, cumulative = FALSE, ...)
}
\arguments{
\item{plot}{a \link{plotdap} object.}

\item{table}{a \link{tabledap} object.}

\item{var}{a formula defining a variable, or function of variables to visualize.}

\item{color}{either a character string of length 1 matching a name in \link[rerddap]{colors}
or a vector of color codes. This defines the colorscale used to encode values
of \code{var}.}

\item{size}{the size of the symbol.}

\item{shape}{the shape of the symbol. For valid options, see the 'pch' values
section on \link{points}. \code{plot(0:25, 0:25, pch = 0:25)} also gives a
quick visual of the majority of possibilities.}

\item{animate}{whether to animate over the \code{time} variable (if it exists).
Currently only implemented for \code{method='ggplot2'} and requires the
gganimate package.}

\item{cumulative}{- if animation should be cumulative -default FALSE}

\item{...}{arguments passed along to \code{geom_sf()} (if \code{method='ggplot2'}, otherwise ignored).}
}
\value{
A plotdap object
}
\description{
\code{add_tabledap} adds the data from an 'rerddap::tabledap()' call to
a 'plotdap' map
}
\examples{

# base plotting tends to be faster,
# but is less extensible plotdap("base")

# test datasets in data folder to meet execution timings
# code given to extract the data

\donttest{
sardines <- tabledap(
 'FRDCPSTrawlLHHaulCatch',
 fields = c('latitude',  'longitude', 'time', 'scientific_name', 'subsample_count'),
  'time>=2010-01-01', 'time<=2012-01-01',
  scientific_name="Sardinops sagax"
  )
}

p <- plotdap()
p1 <- add_tabledap(p, sardines, ~subsample_count)
p2 <- add_tabledap(p, sardines, ~log2(subsample_count))

# using base R plotting
p <- plotdap("base")
p <- add_tabledap(p, sardines, ~subsample_count)

# robinson projection
p <- plotdap(crs = "+proj=robin")
p <- add_tabledap(p, sardines, ~subsample_count)


}
