% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdap-package.R
\docType{package}
\name{plotdap-package}
\alias{plotdap-package}
\alias{_PACKAGE}
\title{plotdap: Easily Visualize Data from 'ERDDAP' Servers via the 'rerddap' Package}
\description{
Easily visualize and animate 'tabledap' and 'griddap' objects obtained via the
'rerddap' package in a simple one-line command,  using either base graphics or
'ggplot2' graphics. 'plotdap' handles extracting and reshaping the data,  map
 projections and continental outlines.  Optionally the data can be animated
 through time using the 'gganmiate' package.#'
}
\details{
The package contains four main functions:
}
\section{Main Functions}{

\itemize{
\item \code{plotdap} - Visualize data returned from rerddap servers.
\item \code{add_griddap} - Add rerddap::griddap() data to a plotdap map
\item \code{add_tabledap} - Add rerddap::tabledap data to a plotdap map
\item \code{add_ggplot} - Add ggplot2 elements to a plotdap object
 }
#'
 @section Details:
Besides the terse help documents,  more  detail in using the
functions are given  in the included vignette "using_plotdap". The datasets used
in the vignette are included in the "data" directory.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/rmendels/plotdap}
  \item Report bugs at \url{https://github.com/rmendels/plotdap/issues}
}

}
\author{
\strong{Maintainer}: Roy Mendelssohn \email{roy.mendelssohn@noaa.gov} [contributor]

Authors:
\itemize{
  \item Carson Sievert
}

}
\keyword{internal}
