% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{sortBoxplot}
\alias{sortBoxplot}
\title{Produce box-and-whisker plot(s) ordered by function such as 
mean or median.}
\usage{
sortBoxplot(
  formula,
  data = NULL,
  decreasing = TRUE,
  FUN = "median",
  idx = NULL,
  col = "gray",
  ...
)
}
\arguments{
\item{formula}{a formula, such as 'y ~ Condition', where 'y' is a numeric vector
of data values to be split into groups according to the
grouping variable 'Condition' (usually a factor).}

\item{data}{a data.frame from which the variables in 'formula'
should be taken.}

\item{decreasing}{Logical:  Indicating whether the sort should be 
increasing or decreasing.}

\item{FUN}{a function to compute the summary statistics which can be
applied to all data subsets.}

\item{idx}{Numeric vector providing the ordering of groups instead of 
specifying a function in \code{FUN}. Only is used when \code{FUN} is set 
to NULL.}

\item{col}{Fill color of the boxplots. Alias for \code{boxfill}.}

\item{...}{Other parameters to adjust the layout of the boxplots. 
See \code{\link[graphics]{bxp}}.}
}
\value{
The ordered stats.
}
\description{
Produce box-and-whisker plot(s) ordered by function such as 
mean or median. Wrapper around \code{\link[graphics]{boxplot}}.
}
\examples{
head(ToothGrowth)
# sort on basis of mean length:
sortBoxplot(len ~ dose:supp, data = ToothGrowth)
# sort on basis of median length:
sortBoxplot(len ~ dose:supp, data = ToothGrowth, decreasing=FALSE)
# on the basis of variation (sd):
sortBoxplot(len ~ dose:supp, data = ToothGrowth, FUN='sd', col=alpha(2))
}
\seealso{
Other Functions for plotting: 
\code{\link{addInterval}()},
\code{\link{add_bars}()},
\code{\link{add_n_points}()},
\code{\link{alphaPalette}()},
\code{\link{alpha}()},
\code{\link{check_normaldist}()},
\code{\link{color_contour}()},
\code{\link{dotplot_error}()},
\code{\link{drawDevArrows}()},
\code{\link{emptyPlot}()},
\code{\link{errorBars}()},
\code{\link{fill_area}()},
\code{\link{getCoords}()},
\code{\link{getFigCoords}()},
\code{\link{getProps}()},
\code{\link{gradientLegend}()},
\code{\link{legend_margin}()},
\code{\link{marginDensityPlot}()},
\code{\link{plot_error}()},
\code{\link{plot_image}()},
\code{\link{plotsurface}()}
}
\author{
Jacolien van Rij
}
\concept{Functions for plotting}
