% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resize_to_standard.R
\name{resize_to_standard}
\alias{resize_to_standard}
\title{Resize an Image According to the Other Image or to Ratios}
\usage{
resize_to_standard(x, standard = 0.5, what = "all", scale = TRUE)
}
\arguments{
\item{x}{the image you want to resize.}

\item{standard}{either the image whose size is the 
standard or two ratios. When it specifies two ratios, 
it should be a numeric vector whose first and second 
elements are multipliers for width and height. For 
example, x's width and height are 100 and 60, and 
\code{standard = c(0.5, 3)}, then the result 
image's width and height will be 50 and 180. If one of 
the two number is NA, then the dimension represented 
by this NA will be modified automatically.}

\item{what}{this parameter is used only when 
\code{standard} is an image. It specifies 
the way to resize. When it 
is "width", let x's width be the same 
as \code{standard}; whether its height is 
automatically scaled depends on \code{scale}.
When it is "height", 
let x's height be the same as \code{standard}; whether
its width is automatically scaled 
depends on \code{scale}. When it is  "all" (or "both"), 
the default, 
let x's width and height
be the same as \code{standard}. When it is two number 
linked with a "_", it means resizing a according to 
b's width and height multiplied. For example, 
if it is "3_2" and b's width and height are 50, 70, then 
the result's width and height are 50 * 3 = 150, 
70 * 2 = 140. Forms like "_2" or "3_" are also accepted.}

\item{scale}{Default is TRUE. It is only used when 
only one of width and height is to 
be modified. This parameter 
decises whether the image is automatically scaled.}
}
\description{
Simple wrapper of \code{magick::image_resize}.
See the parameters below.
}
