% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{add_trace}
\alias{add_trace}
\title{Add a trace to a plotly visualization}
\usage{
add_trace(p = last_plot(), ..., group, color, colors, symbol, symbols, size,
  data = NULL, evaluate = FALSE)
}
\arguments{
\item{p}{A plotly object.}

\item{...}{These arguments are documented in the references section below.
Note that acceptable arguments depend on the trace type.}

\item{group}{Either a variable name or a vector to use for grouping. If used, 
a different trace will be created for each unique value.}

\item{color}{Either a variable name or a vector to use for color mapping.}

\item{colors}{Either a colorbrewer2.org palette name (e.g. "YlOrRd" or "Blues"), 
or a vector of colors to interpolate in hexadecimal "#RRGGBB" format, 
or a color interpolation function like \code{colorRamp}.}

\item{symbol}{Either a variable name or a (discrete) vector to use for symbol encoding.}

\item{symbols}{A character vector of symbol types. Possible values:
'dot', 'cross', 'diamond', 'square', 'triangle-down', 'triangle-left', 'triangle-right', 'triangle-up'}

\item{size}{A variable name or numeric vector to encode the size of markers.}

\item{data}{A data frame to associate with this trace (optional). If not 
provided, arguments are evaluated using the data frame in \code{\link{plot_ly}()}.}

\item{evaluate}{logical. Evaluate arguments when this function is called?}
}
\description{
Add a trace to a plotly visualization
}
\author{
Carson Sievert
}
\references{
\url{https://plot.ly/r/reference/}
}
\seealso{
\code{\link{plot_ly}()}
}

