# plotmo.methods.misc.R: plotmo method functions for miscellaneous objects
#
# See the descriptions of the methods in plotmo.methods.R.
#
# TODO add a lars test to the plotmo test suite

get.plotmo.pairs.randomForest <- function(object, env, x, ...)
{
    order.randomForest.vars.on.importance <- function(object, x)
    {
        importance <- object$importance
        if(!is.matrix(importance) ||           # sanity checks
                nrow(importance) == 0 ||
                !identical(row.names(importance), colnames(x))) {
            warning0("randomForest object has an invalid ",
                     "\"importance\" field, try all2=T")
            return(NULL)
        }
        # vector of var indices, most important vars first
        order(importance[,1], decreasing=TRUE)
    }
    if(is.null(object$forest))
        stop0("object has no \"forest\" component ",
              "(use keep.forest=TRUE in the call to randomForest)")
    importance <- order.randomForest.vars.on.importance(object, x)
    if(is.null(importance))
        return(NULL)
    # pairs of four most important variables
    form.pairs(importance[1: min(4, length(importance))])
}
plotmo.predict.quantregForest <- function(object, newdata, type, ...)
{
    predict(object, newdata=newdata, quantiles=.5)
}
get.plotmo.default.type.lars <- function(obj, ...)
{
    "fit"
}
plotmo.predict.lars <- function(object, newdata, type, ...)
{
    if(pmatch(type, "coefficients", 0))
        stop0("predict.lars type=\"coefficients\" cannot be used with plotmo")

    # just a skeleton for now, s and mode not specified
    predict(object, newx=newdata, type=type)$fit
}
get.plotmo.default.type.bruto <- function(obj, ...)
{
    "fitted"
}
plotmo.predict.bruto <- function(object, newdata, type, ...)
{
    # TODO fails: predict.bruto returned a response of the wrong length (got 31 expected 27)
    predict(object, newx=as.matrix(newdata), type=type)
}
plotmo.predict.lda <- function(object, newdata, type, trace)
{
    y <- predict(object, newdata, type=type)    # calls predict.lda
    get.lda.yhat(object, y, type, trace)
}
plotmo.predict.qda <- function(object, newdata, type, trace)
{
    y <- predict(object, newdata, type=type)    # calls predict.qda
    get.lda.yhat(object, y, type, trace)
}
# Special handling for MASS lda and qda predicted response, which
# is a data.frame with columns "x", "class", and "posterior".
# Here we use plotmo's type argument to choose a column.

get.lda.yhat <- function(object, yhat, type, trace)
{
    yhat1 <- switch(match.choices(type,
                         c("response", "ld", "class", "posterior"), "type"),
           yhat$x,              # response (default)
           yhat$x,              # ld
           yhat$class,          # class
           yhat$posterior)      # posterior

    if(is.null(yhat1)) {
        msg <- paste0(
            if(!is.null(yhat$x)) "type=\"response\" " else "",
            if(!is.null(yhat$class)) "type=\"class\" " else "",
            if(!is.null(yhat$posterior)) "type=\"posterior\" " else "")
        stop0("type=\"", type, "\" is illegal for predict.", class(object)[1], ".  ",
              if(nchar(msg)) paste("Use one of:", msg) else "",
              "\n")
    }
    yhat1
}
get.plotmo.default.type.fda <- function(obj, ...)
{
    "class"
}
get.plotmo.default.type.varmod <- function(object, env, trace)
{
    "se"
}
get.plotmo.x.varmod <- function(object, env, trace)
{
    get.plotmo.x(object$parent, env, trace)
}
get.plotmo.y.varmod <- function(object, env, y.column, expected.len, trace)
{
    get.plotmo.y(object$residmod, env, y.column, expected.len, trace)
}

# # Simple interface for the AMORE package.
# # Thanks to Bernard Nolan and David Lorenz for these.
# # Commented out to avoid having suggests(AMORE) in plotmo DESCRIPTION file.
#
# get.plotmo.x.MLPnet <- function(object, ...)
# {
#     get("P", pos=1)
# }
# get.plotmo.y.MLPnet <- function(object, ...)
# {
#     get("T", pos=1)
# }
# predict.MLPnet <- function(object, newdata, ...)
# {
#     library(AMORE)
#     sim.MLPnet(object, newdata, ...)
# }

# TODO Following commented out because polyreg is not supported by plotmo
# So with comment out we support plotmo(fda.object) but not plotmo(fda.object$fit).
# If not not commented out, we would support neither.
#
# get.plotmo.singles.fda <- function(object, env, x, trace, all1)
# {
#   if(trace > 0) {
#       trace <- 2
#       cat("Invoking get.plotmo.x.wrapper for embedded fda object\n")
#   }
#   x <- get.plotmo.x.wrapper(object$fit, env, trace)
#     get.plotmo.singles(object$fit, env, x, trace, all1)
# }
# get.plotmo.pairs.fda <- function(object, env, x, trace, all2)
# {
#   if(trace > 0) {
#       trace <- 2
#       cat("Invoking get.plotmo.x.wrapper for embedded fda object\n")
#   }
#   x <- get.plotmo.x.wrapper(object$fit, env, trace)
#     get.plotmo.pairs(object$fit, env, x, trace, all2)
# }
