% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_pmap_file.R
\name{render_pmap_file}
\alias{render_pmap_file}
\title{Render the process map as a file}
\usage{
render_pmap_file(p, 
   file_name, format = NULL, 
   width = NULL, height = NULL,
   use_external_dot = FALSE)
}
\arguments{
\item{p}{the process map created by \code{create_pmap()}}

\item{file_name}{the file name to be stored}

\item{format}{the file format, it can be \code{NULL}(default), \code{png}, \code{pdf}, \code{svg} and \code{ps}. If it's \code{NULL}, the format will be guessed from the \code{file_name} extension.}

\item{width}{width of the image (optional)}

\item{height}{height of the image (optional)}

\item{use_external_dot}{Whether to use external \code{dot} command to generate the file}
}
\description{
You can save the process map to a file
}
\details{
The function depends on V8 engine, so please install \code{v8} engine support on your platform before use the function.
\itemize{
\item For Ubuntu/Debian user, please install \code{libv8-dev} package;
\item For Fedora/RHEL user, please install \code{v8-devel} package;
\item For macOS user, please \code{brew install v8@3.15};
}

Example:\preformatted{library(dplyr)
library(pmap)
eventlog <- generate_eventlog()
p <- create_pmap(eventlog)
render_pmap_file(p, file_name = "test.svg")
}
}
