% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmc.R, R/template-package.r
\docType{package}
\name{pmc}
\alias{pmc}
\title{pmc}
\usage{
pmc(
  tree,
  data,
  modelA,
  modelB,
  nboot = 500,
  optionsA = list(),
  optionsB = list(),
  ...,
  mc.cores = parallel::detectCores()
)
}
\arguments{
\item{tree}{A phylogenetic tree.  Can be phylo (ape) or ouch tree}

\item{data}{The data matrix}

\item{modelA}{a model from the list, or a custom model, see details}

\item{modelB}{any other model from the list, or custom model, see details}

\item{nboot}{number of bootstrap replicates to use}

\item{optionsA}{additional arguments to modelA}

\item{optionsB}{additional arguments to modelB}

\item{...}{additional arguments to both fitting methods}

\item{mc.cores}{number of parallel cores to use}
}
\value{
list with the nboot likelihood ratios obtained from fitting both models
to data simulated by model A, and the nboot likelihood ratios obtained
by fitting both models to simulations from model B, and the likelihood 
ratio between the original MLE estimated models from the data.
}
\description{
Performs a phylogenetic monte carlo between modelA and modelB
}
\details{
Simulates data under each model and returns the distribution of 
likelihood ratio, L(B)/L(A), under for both simulated datasets.
}
\examples{
library("geiger")
geo=get(data(geospiza))
tmp=treedata(geo$phy, geo$dat)
phy=tmp$phy
dat=tmp$data[,1]
\donttest{ 
pmc(phy, dat, "BM", "lambda", nboot = 20, mc.cores=1)
}
}
