% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{globalstd}
\alias{globalstd}
\title{GlobalStd algorithm with structure/reaction directed analysis}
\usage{
globalstd(list, rtcutoff = 10, ng = 10, corcutoff = NULL,
  freqcutoff = 10)
}
\arguments{
\item{list}{a peaks list with mass to charge, retention time and intensity data}

\item{rtcutoff}{cutoff of the distances in cluster, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{freqcutoff}{cutoff of frequency of PMDs between RT cluster for independent peaks, default 10}
}
\value{
list with GlobalStd algorithm processed data.
}
\description{
GlobalStd algorithm with structure/reaction directed analysis
}
\examples{
\donttest{
data(spmeinvivo)
re <- globalstd(spmeinvivo)
}
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotstd}},\code{\link{plotstdsda}},\code{\link{plotstdrt}}
}
