% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibble.R
\name{as_pibble}
\alias{as_pibble}
\alias{as_pibble.tbl_df}
\alias{as_pibble.grouped_df}
\alias{as_pibble.data.frame}
\alias{as_pibble.list}
\title{Coerce to a pibble panel data set object}
\usage{
as_pibble(x, .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE, ...)

\method{as_pibble}{tbl_df}(x, .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE, ...)

\method{as_pibble}{grouped_df}(x, .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE, ...)

\method{as_pibble}{data.frame}(x, .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE, ...)

\method{as_pibble}{list}(x, .i = NULL, .t = NULL, .d = 1, .uniqcheck = FALSE, ...)
}
\arguments{
\item{x}{A data frame, tibble or list}

\item{.i}{Quoted or unquoted variable(s) that identify the individual cases. If this is omitted, \code{pibble} will assume the data set is a single time series.}

\item{.t}{Quoted or unquoted variable indicating the time. \code{pmdplyr} accepts two kinds of time variables: numeric variables where a fixed distance \code{.d} will take you from one observation to the next, or, if \code{.d=0}, any standard variable type with an order. Consider using the \code{time_variable()} function to create the necessary variable if your data uses a \code{Date} variable for time.}

\item{.d}{Number indicating the gap in \code{t} between one period and the next. For example, if \code{.t} indicates a single day but data is collected once a week, you might set \code{.d=7}. To ignore gap length and assume that "one period ago" is always the most recent prior observation in the data, set \code{.d=0}. By default, \code{.d=1}.}

\item{.uniqcheck}{Logical parameter. Set to TRUE to perform a check of whether \code{.i} and \code{.t} uniquely identify observations, and present a message if not. By default this is set to FALSE and the warning message occurs only once per session.}

\item{...}{Other arguments passed on to individual methods.}
}
\description{
This function coerces a tibble, data.frame, or list to a pibble tibble by adding the \code{.i}, \code{.t}, and \code{.d} attributes to it.
}
\details{
\itemize{
  \item \code{.i}, Quoted or unquoted variable(s) indicating the individual-level panel identifier
  \item \code{.t}, Quoted or unquoted variable indicating the time variable
  \item \code{.d}, a number indicating the gap
}

Note that pibble does not require that \code{.i} and \code{.t} uniquely identify the observations in your data, but it will give a warning message (a maximum of once per session, unless \code{.uniqcheck=TRUE}) if they do not.
}
\examples{
data(SPrail)
# I set .d=0 here to indicate that I don't care how large the gap
# between one period and the next is.
# If I want to use 'insert_date' for .t with a fixed gap between periods,
# I need to transform it into an integer first; see time_variable()
SP <- as_pibble(SPrail,
  .i = c(origin, destination),
  .t = insert_date,
  .d = 0
)
is_pibble(SP)
attr(SP, ".i")
attr(SP, ".t")
attr(SP, ".d")

data(Scorecard)
# Here, year is an integer, so I can use it with .d = 1 to
# indicate that one period is a change of one unit in year
# Conveniently, .d = 1 is the default
Scorecard <- as_pibble(Scorecard, .i = unitid, .t = year)
is_pibble(Scorecard)
}
