df <- pibble(
  i = 1:2,
  X = 3:4,
  .i = i
)

# Here, run all methods to ensure they hold on to tbl_pb status
# Also run scoped variants just to make sure they don't mess anything up
test_that("tbl_pb methods maintain tbl_pb", {
  expect_s3_class(df %>% dplyr::mutate(y = 1), "tbl_pb")
  expect_s3_class(df %>% dplyr::mutate_all(.funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::distinct(), "tbl_pb")
  expect_s3_class(df %>% dplyr::mutate_at("i", .funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::mutate_if(is.numeric, .funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::group_by(i), "tbl_pb")
  expect_s3_class(df %>% dplyr::group_by_all(), "tbl_pb")
  expect_s3_class(df %>% dplyr::group_by_at("i"), "tbl_pb")
  expect_s3_class(df %>% dplyr::group_by_if(is.numeric), "tbl_pb")
  expect_s3_class(df %>% dplyr::ungroup(), "tbl_pb")
  expect_s3_class(df %>% dplyr::bind_cols(y = 1:2), "tbl_pb")
  expect_s3_class(df %>% dplyr::intersect(df), "tbl_pb")
  expect_s3_class(df %>% dplyr::union(df), "tbl_pb")
  expect_s3_class(df %>% dplyr::union_all(df), "tbl_pb")
  expect_s3_class(df %>% dplyr::setdiff(df), "tbl_pb")
  expect_s3_class(df %>% dplyr::inner_join(df), "tbl_pb")
  expect_s3_class(df %>% dplyr::select(i), "tbl_pb")
  expect_s3_class(df %>% dplyr::select_all(), "tbl_pb")
  expect_s3_class(df %>% dplyr::select_at("i"), "tbl_pb")
  expect_s3_class(df %>% dplyr::select_if(is.numeric), "tbl_pb")
  expect_s3_class(df %>% dplyr::rename(y = X), "tbl_pb")
  expect_s3_class(df %>% dplyr::rename_all(tolower), "tbl_pb")
  expect_s3_class(df %>% dplyr::rename_if(is.numeric, tolower), "tbl_pb")
  expect_s3_class(df %>% dplyr::rename_at("X", tolower), "tbl_pb")
  expect_s3_class(df %>% dplyr::summarize(i = mean(i)), "tbl_pb")
  expect_s3_class(df %>% dplyr::summarize_all(mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::summarize_at("i", .funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::summarize_if(is.numeric, .funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::transmute(i = X), "tbl_pb")
  expect_s3_class(df %>% dplyr::transmute_all(.funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::transmute_if(is.numeric, .funs = mean), "tbl_pb")
  expect_s3_class(df %>% dplyr::transmute_at("i", .funs = mean), "tbl_pb")
})

# And the .i attribute
test_that("tbl_pb methods maintain .i", {
  expect_identical(df %>% dplyr::mutate(y = 1) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::mutate_all(.funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::distinct() %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::mutate_at("i", .funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::mutate_if(is.numeric, .funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::group_by(i) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::group_by_all() %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::group_by_at("i") %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::group_by_if(is.numeric) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::ungroup() %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::bind_cols(y = 1:2) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::intersect(df) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::union(df) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::union_all(df) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::setdiff(df) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::inner_join(df) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::select(i) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::select_all() %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::select_at("i") %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::select_if(is.numeric) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::rename(y = X) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::rename_all(tolower) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::rename_if(is.numeric, tolower) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::rename_at("X", tolower) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::summarize(i = mean(i)) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::summarize_all(mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::summarize_at("i", .funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::summarize_if(is.numeric, .funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::transmute(i = X) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::transmute_all(.funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::transmute_if(is.numeric, .funs = mean) %@% ".i" %>% unname(), "i")
  expect_identical(df %>% dplyr::transmute_at("i", .funs = mean) %@% ".i" %>% unname(), "i")
})
