% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_output_field.R
\name{add_output_field}
\alias{add_output_field}
\title{Add Output nodes to a PMML object.}
\usage{
add_output_field(xml_model = NULL, outputNodes = NULL, at = "End",
  xformText = NULL, nodeName = NULL, attributes = NULL,
  whichOutput = 1, namespace = "4_3")
}
\arguments{
\item{xml_model}{The PMML model to which the OutputField elements are to be added}

\item{outputNodes}{The Output nodes to be added. These may be created using the
'make_output_nodes' helper function}

\item{at}{Given an Output element, the 1 based index after which the given Output
child element should be inserted at}

\item{xformText}{Post-processing information to be included in the OutputField element.
This expression will be processed by the function_to_pmml function}

\item{nodeName}{The name of the element to be added}

\item{attributes}{The attributes to be added}

\item{whichOutput}{The index of the Output element}

\item{namespace}{The namespace of the PMML model}
}
\value{
Output node with the OutputField elements inserted.
}
\description{
Add Output nodes to a PMML object.
}
\details{
This function is meant to add any post-processing information to an existing model via
the OutputField element. One can also use this to tell the PMML model to output other values
not automatically added to the model output.
  The first method is to use the 'make_output_nodes' helper function to make a list of output
elements to be added. 'whichOutput' lets the function know which of the Output elements we want to
work with; there may be more than one in a multiple model file. One can then add those elements there,
at the desired index given by the 'at' parameter; the elements are inserted after the OutputField
element at the 'at' index. In other words, find the 'whichOutput' Output element, add the 'outputNodes'
child elements (which should be OutputField nodes) at the 'at' position in the child nodes.
  This function can also be used with the 'nodeName' and 'attributes' to add the list of attributes to
an OutputField element with name 'nodeName' element using the 'xml_model', 'outputNodes' and 'at' parameters.
  Finally, one can use this to add the transformation expression given by the 'xformText' parameter
to the node with name 'nodeName'. The string given via 'xformText' is converted to an XML expression similarly
to the function_to_pmml function. In other words, find the OutputField node with tha name 'nodeName' and add
the list of attributes given with 'attributes' and also, add the child transformations given in the 'xformText'
parameter.
}
\examples{
# Load the standard iris dataset
data(iris)

# Create a linear model and convert it to PMML
mod <- lm(Sepal.Length ~ ., iris)
pmod <- pmml(mod)

# Create additional output nodes
onodes0 <- make_output_nodes(
  name = list("OutputField", "OutputField"),
  attributes = list(list(
    name = "dbl",
    optype = "continuous"
  ), NULL),
  expression = list("ln(x)", "ln(x/(1-x))")
)
onodes2 <- make_output_nodes(
  name = list("OutputField", "OutputField"),
  attributes = list(
    list(
      name = "F1",
      dataType = "double", optype = "continuous"
    ),
    list(name = "F2")
  )
)

# Create new pmml objects with the output nodes appended
add_output_field(
  xml_model = pmod, outputNodes = onodes2, at = "End",
  xformText = NULL, nodeName = NULL, attributes = NULL,
  whichOutput = 1
)
pmod2 <- add_output_field(
  xml_model = pmod, outputNodes = onodes0, at = "End",
  xformText = NULL, nodeName = NULL,
  attributes = NULL, whichOutput = 1
)

# Create nodes with attributes and transformations
add_output_field(xml_model = pmod2, outputNodes = onodes2, at = 2)
add_output_field(
  xml_model = pmod2, xformText = list("exp(x) && !x"),
  nodeName = "Predicted_Sepal.Length"
)

att <- list(datype = "dbl", optpe = "dsc")
add_output_field(
  xml_model = pmod2, nodeName = "Predicted_Sepal.Length",
  attributes = att
)
}
\author{
Tridivesh Jena
}
