% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{check_run_stage_args}
\alias{check_run_stage_args}
\title{Test the arguments to the run_stage function for correctness}
\usage{
check_run_stage_args(
  pmwgs,
  stage,
  iter,
  particles,
  display_progress,
  n_cores,
  n_unique,
  epsilon,
  mix,
  pdist_update_n
)
}
\arguments{
\item{pmwgs}{A Particle Metropolis within Gibbs sampler which has been set
up and initialised}

\item{stage}{The sampling stage to run. Must be one of \code{'burn'},
\code{'adapt'} or \code{'sample'}.}

\item{iter}{The number of iterations to run for the sampler. For
\code{'burn'} and \code{'sample'} all iterations will run. However for
\code{'adapt'} if all subjects have enough unique samples to create the
conditional distribution then the stage will finish early.}

\item{particles}{The default here is 1000 particles to be generated for each
iteration, however during the sample phase this should be reduced.}

\item{display_progress}{Display a progress bar during sampling.}

\item{n_cores}{Set to more than 1 to use \code{mclapply}. Setting
\code{n_cores} greater than 1 is only permitted on Linux and Mac OS X
machines.}

\item{n_unique}{A number representing the number of unique samples to check
for on each iteration of the sampler (An initial test for the generation
of the proposal distribution). Only used during the \code{'adapt'} stage.}

\item{epsilon}{A value between 0 and 1 that controls the extent to which the
covariance matrix is scaled when generating particles from the previous
random effect. The default will be chosen based on the number of random
effects in the model.}

\item{mix}{A vector of floats that controls the mixture of different sources
for particles. The function \code{\link{numbers_from_proportion}} is
passed this value and includes extra details on what is accepted.}

\item{pdist_update_n}{The number of iterations in the sample stage after
which the proposal distribution will be recomputed.}
}
\description{
Takes the arguments to run_stage and checks them for completeness and
correctness. Returns a list of cleaned/checked arguments to the caller.
}
\keyword{internal}
