% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ss_2cmt_linear_oral_0_lag.R
\name{calc_ss_2cmt_linear_oral_0_lag}
\alias{calc_ss_2cmt_linear_oral_0_lag}
\title{Calculate C(t) for a 2-compartment linear model at steady-state with zero-order oral dosing and a lag time}
\usage{
calc_ss_2cmt_linear_oral_0_lag(tad, CL, V1, V2, Q, dur, dose, tau, tlag)
}
\arguments{
\item{tad}{Time after last dose (h)}

\item{CL}{Clearance (L/h)}

\item{V1}{Central volume of distribution (L)}

\item{V2}{Peripheral volume of distribution (L)}

\item{Q}{Intercompartmental clearance (L/h)}

\item{dur}{Duration of zero-order absorption (h)}

\item{dose}{Steady state dose}

\item{tau}{Dosing interval (h)}

\item{tlag}{Lag time (h)}
}
\value{
Concentration of drug at requested time (\code{tad}) at steady-state, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 2-compartment linear model at steady-state with zero-order oral dosing and a lag time
}
\examples{
Ctrough <- calc_ss_2cmt_linear_oral_0_lag(tad = 23, CL = 2.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, dur = 1, tau = 24, tlag=2)

}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
