% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derived.R
\name{calc_derived}
\alias{calc_derived}
\alias{calc_derived_1cpt}
\alias{calc_derived_2cpt}
\alias{calc_derived_3cpt}
\title{Calculate derived pharmacokinetic parameters for a 1-, 2-, or 3-compartment linear model.}
\usage{
calc_derived(..., verbose = FALSE)

calc_derived_1cpt(
  CL,
  V = NULL,
  V1 = NULL,
  ka = NULL,
  tlag = NULL,
  type = "all",
  sigdig = 5
)

calc_derived_2cpt(
  CL,
  V1 = NULL,
  V2,
  Q2 = NULL,
  V = NULL,
  Q = NULL,
  ka = NULL,
  tlag = NULL,
  type = "all",
  sigdig = 5
)

calc_derived_3cpt(
  CL,
  V1 = NULL,
  V2,
  V3,
  Q2 = NULL,
  Q3,
  V = NULL,
  Q = NULL,
  ka = NULL,
  tlag = NULL,
  type = "all",
  sigdig = 5
)
}
\arguments{
\item{...}{Passed to the other `calc_derived_*()` functions.}

\item{verbose}{For `calc_derived()`, provide a message indicating the type of model detected.}

\item{CL}{Clearance (L/h)}

\item{V1, V}{Central volume of distribution (L).  Values are synonyms; use only one.}

\item{ka}{Absorption rate (1/hr)}

\item{tlag}{Absorption lag time (hr)}

\item{type}{Parameters to return. Default is \code{"all"}; see details for other options that are specific to the number of compartments.}

\item{sigdig}{Number of significant digits to be returned. Default is \code{5}.}

\item{V2}{First peripheral volume of distribution (L)}

\item{Q2, Q}{Intercompartmental clearance from central to first peripheral compartment (L/h).  Values are synonyms; use only one.}

\item{V3}{Second peripheral volume of distribution (L)}

\item{Q3}{Intercompartmental clearance from central to second peripheral compartment (L/h)}
}
\value{
Return a list of derived PK parameters for a 1-, 2-, or 3-compartment linear model given provided clearances and volumes based on the `type`.
\itemize{ 
  \item \code{Vss}: Volume of distribution at steady state, \eqn{V_{ss}} (L); 1-, 2-, and 3-compartment
  \item \code{k10}: First-order elimination rate, \eqn{k_{10}} (/h); 1-, 2-, and 3-compartment
  \item \code{k12}: First-order rate of transfer from central to first peripheral compartment, \eqn{k_{12}} (/h); 2- and 3-compartment
  \item \code{k21}: First-order rate of transfer from first peripheral to central compartment, \eqn{k_{21}} (/h); 2- and 3-compartment
  \item \code{k13}: First-order rate of transfer from central to second peripheral compartment, \eqn{k_{13}} (/h); 3-compartment
  \item \code{k31}: First-order rate of transfer from second peripheral to central compartment,\eqn{k_{31}} (/h); 3-compartment
  \item \code{thalf_alpha}: \eqn{t_{1/2,\alpha}} (h); 1-, 2-, and 3-compartment
  \item \code{thalf_beta}: \eqn{t_{1/2,\beta}} (h); 2- and 3-compartment
  \item \code{thalf_gamma}: \eqn{t_{1/2,\gamma}} (h); 3-compartment
  \item \code{alpha}: \eqn{\alpha}; 1-, 2-, and 3-compartment
  \item \code{beta}: \eqn{\beta}; 2- and 3-compartment
  \item \code{gamma}: \eqn{\beta}; 3-compartment
  \item \code{trueA}: true A; 1-, 2-, and 3-compartment
  \item \code{trueB}: true B; 2- and 3-compartment
  \item \code{trueC}: true C; 3-compartment
  \item \code{fracA}: fractional A; 1-, 2-, and 3-compartment
  \item \code{fracB}: fractional B; 2- and 3-compartment
  \item \code{fracC}: fractional C; 3-compartment
 }

The input parameters with standardized names (`V1`, `V2`, `V3`, `CL`, `Q2`,
and `Q3`) are also returned in the list, and if provided, additional PK
parameters of `ka` and `lag` are also returned in the list.  All inputs may
be scalars or vectors.
}
\description{
Calculate derived pharmacokinetic parameters for a 1-, 2-, or 3-compartment linear model.
}
\examples{
params <- calc_derived(CL=29.4, V1=23.4, V2=114, V3=4614, Q2=270, Q3=73)
params <- calc_derived_1cpt(CL=16, V=25)
params <- calc_derived_2cpt(CL=16, V1=25, V2=50, Q=0.5)
params <- calc_derived_3cpt(CL=29.4, V1=23.4, V2=114, V3=4614, Q2=270, Q3=73)
}
\references{
Shafer S. L. \code{CONVERT.XLS}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
