% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LatinHypercubeSampler.R
\name{LatinHypercubeSampler}
\alias{LatinHypercubeSampler}
\title{R6 class to represent a Latin hypercube sampler.}
\description{
\code{\link[R6:R6Class]{R6}} class that generates Latin hypercube samples (using
\code{\link[lhs:randomLHS]{randomLHS}}) for parameters drawn from configured
distributions: \code{\link[stats:Uniform]{uniform}},
\code{\link[stats:Normal]{normal}}, \code{\link[stats:Lognormal]{lognormal}},
\code{\link[stats:Beta]{beta}} or \code{\link[metRology:qtri]{triangular}}.
It generates a data frame of sample values.
}
\examples{
lhs_gen <- LatinHypercubeSampler$new(parameter_names = c("size", "age", "km", "price"))
lhs_gen$set_class_parameter("size", c("small", "medium", "large"))
lhs_gen$set_uniform_parameter("age", lower = 18, upper = 70, decimals = 0)
lhs_gen$set_normal_parameter("km", mean = 50000, sd = 20000, decimals = 0)
lhs_gen$set_lognormal_parameter("price", mean = 30000, sd = 10000, decimals = 0)
lhs_gen$set_beta_parameter("tread", mean = 0.7, sd = 0.1, decimals = 2)
lhs_gen$set_triangular_parameter("rating", lower = 0, upper = 10, mode = 5,
                                 decimals = 1)
lhs_gen$generate_samples(number = 10, random_seed = 123)

}
\section{Super class}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{LatinHypercubeSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{parameter_names}}{A vector of sample parameter names.}

\item{\code{parameter_distributions}}{A list of sample distribution values (nested list with appropriate parameters).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LatinHypercubeSampler-new}{\code{LatinHypercubeSampler$new()}}
\item \href{#method-LatinHypercubeSampler-set_class_parameter}{\code{LatinHypercubeSampler$set_class_parameter()}}
\item \href{#method-LatinHypercubeSampler-set_uniform_parameter}{\code{LatinHypercubeSampler$set_uniform_parameter()}}
\item \href{#method-LatinHypercubeSampler-set_normal_parameter}{\code{LatinHypercubeSampler$set_normal_parameter()}}
\item \href{#method-LatinHypercubeSampler-set_lognormal_parameter}{\code{LatinHypercubeSampler$set_lognormal_parameter()}}
\item \href{#method-LatinHypercubeSampler-set_beta_parameter}{\code{LatinHypercubeSampler$set_beta_parameter()}}
\item \href{#method-LatinHypercubeSampler-set_triangular_parameter}{\code{LatinHypercubeSampler$set_triangular_parameter()}}
\item \href{#method-LatinHypercubeSampler-generate_samples}{\code{LatinHypercubeSampler$generate_samples()}}
\item \href{#method-LatinHypercubeSampler-clone}{\code{LatinHypercubeSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericClass" data-id="new_clone"><a href='../../poems/html/GenericClass.html#method-GenericClass-new_clone'><code>poems::GenericClass$new_clone()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets parameter names when provided.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$new(parameter_names = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_names}}{Optional vector of sample parameter names.}

\item{\code{...}}{Additional parameters passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_class_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_class_parameter}{}}}
\subsection{Method \code{set_class_parameter()}}{
Sets a parameter to sampled from a vector of classes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_class_parameter(parameter_name, classes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{classes}}{Vector of class values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_uniform_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_uniform_parameter}{}}}
\subsection{Method \code{set_uniform_parameter()}}{
Sets a parameter to be sampled from a \code{\link[stats:Uniform]{uniform}} distribution with lower and upper bounds, optionally rounded to a specified number of decimal places.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_uniform_parameter(
  parameter_name,
  lower = 0,
  upper = 1,
  decimals = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{lower}}{Lower bound of the uniform distribution (default = 0).}

\item{\code{upper}}{Upper bound of the uniform distribution (default = 1).}

\item{\code{decimals}}{Optional number of decimals applied to generated samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_normal_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_normal_parameter}{}}}
\subsection{Method \code{set_normal_parameter()}}{
Sets a parameter to be sampled from a \code{\link[stats:Normal]{normal}} distribution with mean and standard deviation, optionally rounded to a specified number of decimal places.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_normal_parameter(
  parameter_name,
  mean = 0,
  sd = 1,
  decimals = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{mean}}{Mean parameter for the normal distribution (default = 0).}

\item{\code{sd}}{Standard deviation parameter for the normal distribution (default = 1).}

\item{\code{decimals}}{Optional number of decimals applied to generated samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_lognormal_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_lognormal_parameter}{}}}
\subsection{Method \code{set_lognormal_parameter()}}{
Sets a parameter to be sampled from a \code{\link[stats:Lognormal]{lognormal}} distribution with log mean and log standard deviation, optionally expressed as regular mean and SD (overriding log mean/sd), and optionally rounded to a specified number of decimal places.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_lognormal_parameter(
  parameter_name,
  meanlog = 0,
  sdlog = 1,
  mean = NULL,
  sd = NULL,
  decimals = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{meanlog}}{Log mean parameter for the lognormal distribution (default = 0).}

\item{\code{sdlog}}{Log standard deviation parameter for the lognormal distribution (default = 1).}

\item{\code{mean}}{Optional (overriding) regular mean parameter for the lognormal distribution (default = NULL).}

\item{\code{sd}}{Optional (overriding) standard deviation parameter for the lognormal distribution (default = NULL).}

\item{\code{decimals}}{Optional number of decimals applied to generated samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_beta_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_beta_parameter}{}}}
\subsection{Method \code{set_beta_parameter()}}{
Sets a parameter to be sampled from a \code{\link[stats:Beta]{beta}} distribution configured with alpha and beta parameters, or optionally with mean and standard deviation (overriding alpha and beta), and optionally rounded to a specified number of decimal places.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_beta_parameter(
  parameter_name,
  alpha = 1,
  beta = 1,
  mean = NULL,
  sd = NULL,
  decimals = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{alpha}}{Shaping (towards 1) parameter (> 0) for the beta distribution (default = 1).}

\item{\code{beta}}{Shaping (towards 0) parameter (> 0) for the beta distribution (default = 1).}

\item{\code{mean}}{Optional (overriding) mean parameter for the beta distribution (default = NULL).}

\item{\code{sd}}{Optional (overriding) standard deviation parameter for the beta distribution (default = NULL).}

\item{\code{decimals}}{Optional number of decimals applied to generated samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-set_triangular_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-set_triangular_parameter}{}}}
\subsection{Method \code{set_triangular_parameter()}}{
Sets a parameter to be sampled from a \code{\link[metRology:qtri]{triangular}} distribution with lower and upper bounds and mode (peak), optionally rounded to a specified number of decimal places.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$set_triangular_parameter(
  parameter_name,
  lower = 0,
  upper = 1,
  mode = (lower + upper)/2,
  decimals = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameter_name}}{Character string name of sample parameter.}

\item{\code{lower}}{Lower bound of the triangular distribution (default = 0).}

\item{\code{upper}}{Upper bound of the triangular distribution (default = 1).}

\item{\code{mode}}{Mode (or peak) of the triangular distribution (default = (lower + upper)/2).}

\item{\code{decimals}}{Optional number of decimals applied to generated samples.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-generate_samples"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-generate_samples}{}}}
\subsection{Method \code{generate_samples()}}{
Generates Latin hypercube sample data (via \code{\link[lhs:randomLHS]{randomLHS}}) for the set parameters using corresponding distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$generate_samples(number = 10, random_seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{Number of samples to generate (default = 10).}

\item{\code{random_seed}}{Optional seed for the random generation of samples.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of generated sample values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LatinHypercubeSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LatinHypercubeSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LatinHypercubeSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
