% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointer.zchron.R
\name{pointer.zchron}
\alias{pointer.zchron}
\title{Calculate pointer years using z-transformation of a site chronology}
\usage{
pointer.zchron(data, period = NULL, bi.weight = TRUE,
               z.thresh = 1, t.Test = FALSE, make.plot = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} with detrended tree-ring series as columns and years as rows (e.g., output of \code{detrend} of package dplR).}

\item{period}{a \code{vector} specifying the start and end year of the analysis. Defaults to the full period covered by the data.}

\item{bi.weight}{a \code{logical} flag specifying whether a Tukey's biweight robust mean site chronology should be calculated. Defaults to TRUE.}

\item{z.thresh}{a \code{numeric} specifying the threshold for identification of pointer years. Defaults to 1.}

\item{t.Test}{a \code{logical} flag specifying whether a t-test should be performed. Defaults to FALSE.}

\item{make.plot}{a \code{logical} specifying whether a bar plot indicating pointer years should be created. Defaults to FALSE.}
}
\value{
The function returns a \code{list} containing the following components:
\item{TRIsite}{a \code{data.frame} with the calculated site chronology and corresponding sample depth (output of \code{chron} of package dplR)}
\item{out}{a \code{data.frame} containing the following columns: \code{year} - time stamp, \code{nb.series} - number of series considered, \code{nature} - number indicating whether the year is a positive (1), negative (-1) or no pointer year (0), and \code{AVGztrans} - z-transformed site chronology}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}
}
\description{
The function calculates pointer years on a \code{data.frame} of tree-ring series using a z-transformation of the site chronology (by default based on a biweight robust mean). The method provides the number of standard deviations that the chronology deviates in individual years. To identify pointer years, one absolute threshold on the number of standard deviations can be set. Optionally, a t-test can be applied to test whether the z-transformed chronology significantly exceeds the selected threshold. The function is intended to use on flexibly detrended data, e.g., with a cubic-smoothing spline with a 50\% frequency cut-off at 15 years (cf. Jetschke et al. 2019).
}
\details{
The function develops a site chronology, which is z-transformed over its entire length, thereby providing the number of standard deviations that the chronology deviates in individual years. In developing the site chronology, a normal or biweight robust mean can be used. A threshold \code{z.thresh} on the minimum number of standard deviations can be set (cf. Cropper 1979) to define the years to be considered as pointer years. 
Optionally, a t-test may be performed to test whether the z-transformed chronology significantly differs from the selected threshold value in a particular year. Therefore, individual tree-ring series are z-transformed as well and compared to the threshold value \code{z.thresh}. In case a biweight robust mean is used in building the site chronology, the t-test is based on the biweight robust estimate of the standard deviation. In all t-tests a significance level of 0.05 is used.
}
\examples{
## Calculate pointer years on detrended tree-ring series
data(s033)
detr_s033 <- detrend(s033, method = "Spline", nyrs = 15)
pz1 <- pointer.zchron(detr_s033)
head(pz1$out)

## Calculate pointer years with user-defined arguments
data(s033)
detr_s033 <- detrend(s033, method = "Spline", nyrs = 15)
pz2 <- pointer.zchron(detr_s033, period = c(1950,2010), z.thresh = 1.28,
                      make.plot = TRUE)
head(pz2$out)

}
\references{
Cropper, J.P. (1979) Tree-ring skeleton plotting by computer. \emph{Tree-Ring Bulletin} 39: 47-59.

Jetschke, G., van der Maaten, E. and van der Maaten-Theunissen, M. (2019) Towards the extremes: A critical analysis of pointer year detection methods. \emph{Dendrochronologia} 53: 55-62.
}
\author{
Marieke van der Maaten-Theunissen, Ernst van der Maaten and Gottfried Jetschke.
}
