% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{set_tbl}
\alias{set_tbl}
\title{Set a data table to an \emph{agent} or \emph{informant}}
\usage{
set_tbl(x, tbl)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}

\item{tbl}{The input table for the \code{agent}. This can be a data frame, a
tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object. Any table already
associated with the \emph{agent} or \emph{informant} will be overwritten.}
}
\description{
Setting a data table to an \emph{agent} or \emph{informant} with \code{set_tbl()} replaces
any associated table (a data frame, a tibble, objects of class \code{tbl_dbi} or
\code{tbl_spark}). If a data table is associated with an \emph{agent} or \emph{informant}
along with a table-reading function (settable in \code{\link[=create_agent]{create_agent()}} and
\code{\link[=create_informant]{create_informant()}}'s \code{read_fn} argument or with \code{\link[=set_read_fn]{set_read_fn()}}), the
table-reading function will take precedence. If this is undesirable, it be
removed with the \code{\link[=remove_read_fn]{remove_read_fn()}} function. The association to a table can
be removed with with \code{\link[=remove_tbl]{remove_tbl()}}.
}
\section{Function ID}{

8-3
}

\seealso{
Other Object Ops: 
\code{\link{remove_read_fn}()},
\code{\link{remove_tbl}()},
\code{\link{set_read_fn}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
